/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.utilities;

import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.plugins.workflowdesigner.utilities.FunctionDescriptorUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.TreeMap;

public class WorkflowFunctionUtilities {
    private final DefaultPostFunctionPredicate defaultPostFunctionPredicate;
    private final FunctionDescriptorUtil functionDescriptorUtil;
    private final PluginAccessor pluginAccessor;

    public WorkflowFunctionUtilities(FunctionDescriptorUtil functionDescriptorUtil, ModuleDescriptorFactory moduleDescriptorFactory, PluginAccessor pluginAccessor) {
        this.defaultPostFunctionPredicate = new DefaultPostFunctionPredicate(moduleDescriptorFactory, pluginAccessor);
        this.functionDescriptorUtil = functionDescriptorUtil;
        this.pluginAccessor = pluginAccessor;
    }

    private Collection<ModuleDescriptor<WorkflowPluginFunctionFactory>> getDefaultPostFunctionModuleDescriptors() {
        return this.pluginAccessor.getModuleDescriptors((ModuleDescriptorPredicate)this.defaultPostFunctionPredicate);
    }

    public Collection<FunctionDescriptor> getDefaultPostFunctions() {
        TreeMap postFunctions = Maps.newTreeMap();
        for (ModuleDescriptor<WorkflowPluginFunctionFactory> descriptor : this.getDefaultPostFunctionModuleDescriptors()) {
            WorkflowFunctionModuleDescriptor postFunctionModule = (WorkflowFunctionModuleDescriptor)descriptor;
            FunctionDescriptor postFunction = this.functionDescriptorUtil.makeFunctionDescriptor(postFunctionModule);
            int weight = (Integer)Objects.firstNonNull((Object)postFunctionModule.getWeight(), (Object)Integer.MAX_VALUE);
            postFunctions.put(weight, postFunction);
        }
        return postFunctions.values();
    }

    static class DefaultPostFunctionPredicate
    implements ModuleDescriptorPredicate<WorkflowPluginFunctionFactory> {
        private final EnabledModulePredicate<WorkflowPluginFunctionFactory> isEnabled;
        private final ModuleDescriptorOfTypePredicate<WorkflowPluginFunctionFactory> isPostFunction;

        public DefaultPostFunctionPredicate(ModuleDescriptorFactory moduleDescriptorFactory, PluginAccessor pluginAccessor) {
            this.isEnabled = new EnabledModulePredicate(pluginAccessor);
            this.isPostFunction = new ModuleDescriptorOfTypePredicate(moduleDescriptorFactory, "workflow-function");
        }

        public boolean matches(ModuleDescriptor<? extends WorkflowPluginFunctionFactory> moduleDescriptor) {
            boolean isEnabled = this.isEnabled.matches(moduleDescriptor);
            boolean isPostFunction = this.isPostFunction.matches(moduleDescriptor) && moduleDescriptor instanceof WorkflowFunctionModuleDescriptor;
            return isEnabled && isPostFunction && ((WorkflowFunctionModuleDescriptor)moduleDescriptor).isDefault();
        }
    }
}

