/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.utilities;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UserProjectWorkflowUtilities {
    private final PermissionManager permissionManager;
    private final ProjectService projectService;
    private final WorkflowSchemeManager workflowSchemeManager;

    public UserProjectWorkflowUtilities(PermissionManager permissionManager, ProjectService projectService, WorkflowSchemeManager workflowSchemeManager) {
        this.permissionManager = permissionManager;
        this.projectService = projectService;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    public List<Project> getAllProjects(ApplicationUser user) {
        ServiceOutcome projects = this.projectService.getAllProjectsForAction(user, ProjectAction.VIEW_PROJECT);
        return projects.isValid() ? (List)projects.getReturnedValue() : Collections.emptyList();
    }

    public List<Project> getProjectsForWorkflow(ApplicationUser user, String workflowName) {
        LinkedList projects = Lists.newLinkedList();
        for (Project project : this.getAllProjects(user)) {
            if (!this.projectUsesWorkflow(project, workflowName)) continue;
            projects.add(project);
        }
        return projects;
    }

    public boolean userCanViewWorkflow(ApplicationUser user, String workflowName) {
        if (this.userCanEditWorkflow(user, workflowName)) {
            return true;
        }
        for (Project project : this.getProjectsForWorkflow(user, workflowName)) {
            if (!this.canViewWorkflowReadOnly(user, project) && !this.isProjectAdministrator(user, project)) continue;
            return true;
        }
        return false;
    }

    public boolean userCanEditWorkflow(ApplicationUser user, String workflowName) {
        return this.isAdministrator(user) || this.isSystemAdministrator(user);
    }

    private boolean canViewWorkflowReadOnly(ApplicationUser user, Project project) {
        return this.permissionManager.hasPermission(45, project, user);
    }

    private boolean isAdministrator(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    private boolean isProjectAdministrator(ApplicationUser user, Project project) {
        return this.permissionManager.hasPermission(23, project, user);
    }

    private boolean isSystemAdministrator(ApplicationUser user) {
        return this.permissionManager.hasPermission(44, user);
    }

    private boolean projectUsesWorkflow(Project project, String workflowName) {
        Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
        String defaultWorkflow = (String)workflowMap.get(null);
        if (defaultWorkflow == null) {
            defaultWorkflow = "jira";
        }
        if (defaultWorkflow.equals(workflowName)) {
            return true;
        }
        for (IssueType issueType : project.getIssueTypes()) {
            if (!workflowName.equals(workflowMap.get(issueType.getId()))) continue;
            return true;
        }
        return false;
    }
}

