/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.workflow.SimpleTransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.WorkflowTransitions;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/workflows/transitions")
public class WorkflowTransitionsResource {
    private final WorkflowTransitions transitions;

    public WorkflowTransitionsResource(WorkflowTransitions transitions) {
        this.transitions = transitions;
    }

    @POST
    @Path(value="/common")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response addCommonTransition(@FormParam(value="sourceStatusId") String sourceStatusId, @FormParam(value="transitionId") int transitionId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.transitions.addCommonTransition(sourceStatusId, transitionId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @POST
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response addTransition(@FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId, @FormParam(value="sourceStepId") int sourceStepId, @FormParam(value="targetStepId") int targetStepId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<TransitionData> outcome = this.transitions.addTransitionToWorkflow(name, description, screenId, sourceStepId, targetStepId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        SimpleTransitionData data = new SimpleTransitionData((TransitionData)outcome.getReturnedValue());
        return Responses.createOKResponse(data);
    }

    @DELETE
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response deleteTransition(@FormParam(value="transitionId") int transitionId, @FormParam(value="sourceStepId") int sourceStepId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.transitions.deleteTransition(transitionId, sourceStepId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @PUT
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response updateTransition(@FormParam(value="transitionId") int transitionId, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId, @FormParam(value="sourceStepId") int sourceStepId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result = this.transitions.updateTransition(transitionId, name, description, screenId, sourceStepId, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @POST
    @Path(value="/source")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response updateTransitionSource(@FormParam(value="transitionId") int transitionId, @FormParam(value="newSourceStatusId") String newSourceStatusId, @FormParam(value="originalSourceStatusId") String originalSourceStatusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.transitions.updateTransitionSource(transitionId, newSourceStatusId, originalSourceStatusId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @POST
    @Path(value="/target")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response updateTransitionTarget(@FormParam(value="transitionId") int transitionId, @FormParam(value="targetStatusId") String targetStatusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.transitions.updateTransitionTarget(transitionId, targetStatusId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }
}

