/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.WorkflowGlobalTransitions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/workflows/globalTransitions")
public class WorkflowGlobalTransitionsResource {
    private final Responses responses;
    private final WorkflowGlobalTransitions globalTransitions;

    public WorkflowGlobalTransitionsResource(Responses responses, WorkflowGlobalTransitions globalTransitions) {
        this.responses = responses;
        this.globalTransitions = globalTransitions;
    }

    @POST
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    @WebSudoRequired
    public Response create(@FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId) {
        ServiceOutcome<Workflow> outcome = this.globalTransitions.createGlobalTransition(statusId, workflowName, name, description, screenId);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)outcome.getReturnedValue(), "workflow.designer.adding.global.transition.failed");
    }

    @DELETE
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    @WebSudoRequired
    public Response delete(@FormParam(value="transitionId") String transitionId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.globalTransitions.deleteGlobalTransition(transitionId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @PUT
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    @WebSudoRequired
    public Response update(@FormParam(value="transitionId") int transitionId, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result = this.globalTransitions.updateGlobalTransition(transitionId, name, description, screenId, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }
}

