/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.plugins.workflowdesigner.layout.Status;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transition;
import com.atlassian.jira.plugins.workflowdesigner.layout.UpdateAuthor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class Layout {
    private Set<Status> statuses = new HashSet<Status>();
    private Set<Transition> transitions = new HashSet<Transition>();
    private Date updatedDate;
    private UpdateAuthor updateAuthor;

    public Set<Status> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Set<Status> statuses) {
        this.statuses = statuses;
    }

    public Layout addStatus(Status status) {
        this.statuses.add(status);
        return this;
    }

    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Set<Transition> transitions) {
        this.transitions = transitions;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public UpdateAuthor getUpdateAuthor() {
        return this.updateAuthor;
    }

    public void setUpdateAuthor(UpdateAuthor updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public Set<Transition> getGlobalTransitions() {
        HashSet globalTransitions = Sets.newHashSet(this.transitions);
        Iterables.removeIf((Iterable)globalTransitions, (Predicate)new Predicate<Transition>(){

            public boolean apply(Transition transition) {
                return !transition.isGlobalTransition();
            }
        });
        return globalTransitions;
    }

    public Layout addTransition(Transition transition) {
        this.transitions.add(transition);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Layout layout = (Layout)o;
        if (!this.statuses.equals(layout.statuses)) {
            return false;
        }
        if (!this.transitions.equals(layout.transitions)) {
            return false;
        }
        if (this.updateAuthor != null ? !this.updateAuthor.equals(layout.updateAuthor) : layout.updateAuthor != null) {
            return false;
        }
        return !(this.updatedDate != null ? !this.updatedDate.equals(layout.updatedDate) : layout.updatedDate != null);
    }

    public int hashCode() {
        int result = this.statuses.hashCode();
        result = 31 * result + this.transitions.hashCode();
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        result = 31 * result + (this.updateAuthor != null ? this.updateAuthor.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NewLayoutImpl{statuses=" + this.statuses + ", transitions=" + this.transitions + ", updatedDate=" + this.updatedDate + ", updateAuthor=" + this.updateAuthor + '}';
    }
}

