/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.action;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.component.WorkflowHeaderWebComponent;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class WorkflowDesignerAction
extends JiraWebActionSupport {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;
    private final WorkflowManager workflowManager;
    private final WebResourceManager webResourceManager;
    private final WorkflowHeaderWebComponent workflowHeaderWebComponent;
    private String wfName;
    private String workflowMode;
    private JiraWorkflow workflow;
    private Long project;

    public WorkflowDesignerAction(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, WorkflowManager workflowManager, WebResourceManager webResourceManager, WorkflowHeaderWebComponent workflowHeaderWebComponent) {
        this.permissionManager = permissionManager;
        this.authContext = jiraAuthenticationContext;
        this.webResourceManager = webResourceManager;
        this.workflowManager = workflowManager;
        this.workflowHeaderWebComponent = workflowHeaderWebComponent;
    }

    public String execute() {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return "notloggedin";
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return "nopermission";
        }
        if (StringUtils.isEmpty((String)this.wfName) || StringUtils.isEmpty((String)this.workflowMode) || !this.workflowMode.equals("live") && !this.workflowMode.equals("draft")) {
            return "invalidworkflowname";
        }
        if (this.workflowMode.equals("live") && this.workflowManager.getWorkflow(this.wfName) == null || this.workflowMode.equals("draft") && this.workflowManager.getDraftWorkflow(this.wfName) == null) {
            return "invalidworkflowname";
        }
        this.webResourceManager.requireResourcesForContext("jira.workflow.view");
        return "success";
    }

    public String getWfName() {
        return this.wfName;
    }

    public void setWfName(String wfName) {
        this.wfName = wfName;
    }

    public void setWorkflowMode(String workflowMode) {
        this.workflowMode = workflowMode;
    }

    public JiraWorkflow getWorkflow() {
        if (this.workflow == null) {
            this.workflow = this.workflowMode.equals("live") ? this.workflowManager.getWorkflow(this.wfName) : this.workflowManager.getDraftWorkflow(this.wfName);
        }
        return this.workflow;
    }

    public Long getProject() {
        return this.project;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public String getHeaderHtml() {
        return this.workflowHeaderWebComponent.getHtml(this.getWorkflow(), "workflow_designer", this.getProject());
    }

    public String getLinksHtml() {
        return this.workflowHeaderWebComponent.getLinksHtml(this.getWorkflow(), this.getProject(), "diagram", true);
    }
}

