(function($) {
    var TEMPLATES = atl.plugins.webhooks.admin.templates;

    // filled in on page-load from data attributes
    var ALL_EVENTS = null;
    var NO_EVENTS = null;
    var EVENT_MAPPING = null


    var TransitionModel = Backbone.Model.extend({
    });

    var TransitionCollection = Backbone.Collection.extend({
        initialize: function(options) {
            this.selectionModel = options.selectionModel;
        },
        url: function() {
            var webhookId = this.selectionModel.getSelected().get("self").split("/").splice(-1)[0];
            return contextPath + "/rest/jira-webhook/1.0/jira-webhook/" + webhookId  + "/transitions";
        },
        model: TransitionModel
    });

    var TransitionView = Backbone.View.extend({
        tagName: 'li',
        render: function() {
            var unescapedWorkflowName = this.model.get("workflow");
            var workflowName = AJS.escapeHtml(unescapedWorkflowName);
            var transitionName = AJS.escapeHtml(this.model.get("transition"));
            var workflowLink = AJS.$("<a></a>")
                .attr("href", contextPath + "/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=live&workflowName=" + unescapedWorkflowName)
                .html(workflowName).wrap("<div></div>").parent().html();
            this.$el.append(AJS.I18n.getText("webhooks.transition", transitionName, workflowLink));
        }
    });

    var TransitionsView = Backbone.View.extend({
        el: "#webhook-transitions",
        initialize: function () {
            this.model.selectionModel.onSelectionChange(this.selectionChanged, this);
        },
        render: function() {
            var that = this;
            this.$el.empty();
            if (this.model.length == 0) {
                var noTransitionsMessage = AJS.$("<span></span>").text(AJS.I18n.getText("webhooks.transitions.notransitions"));
                this.$el.append(noTransitionsMessage);
            }

            this.model.each(function (model) {
                var transitionView = new TransitionView({model: model});
                transitionView.render();
                that.$el.append(transitionView.$el);
            });
        },
        selectionChanged: function(selectionModel, selectedModel) {
            if (selectedModel != undefined && selectedModel.get("self") != undefined) {
                var that = this;
                this.model.fetch({
                    success: function(model) { that.render(); }
                });
            } else {
                this.model.reset();
                this.render();
            }
        }
    });

    $.extend(WebHooks, {
        initialize: function($el, selectionModel) {
            var self = this;
            this.$el = $el;

            this.selectionModel = selectionModel;
            this.selectionModel.onSelectionChange(function (selectionModel, selectedModel) {
                this.selectedModel = selectedModel;
            }, this);

			this.$jql = this.$el.find("#webhook-jql").expandOnInput();
			this.$jqlDisplay = this.$el.find("#webhook-jql-display");
			this.$jqlOverlabel = this.$el.find("#webhook-jql-overlabel").overlabel();
			this.$excludeDetails = this.$el.find("#webhook-exclude-details");
			this.$excludeDetailsDisplay = this.$el.find("#webhook-exclude-details-display");
			this.$allEventsCheckbox = this.$el.find("#all-events-checkbox");
			this.$explicitEventsContainer = this.$el.find(".webhook-explicit-events");
			this.$eventsList = this.$el.find("#webhook-events-list");
			this.$explicitEventsList = this.$el.find("#webhook-explicit-events-list");
            this.$explicitEventCheckboxes = this.$explicitEventsList.find("input.checkbox");

            ALL_EVENTS = this.$explicitEventsList.data("all-events-key");
            NO_EVENTS = this.$explicitEventsList.data("no-events-key");
            EVENT_MAPPING = this.$explicitEventsList.data("event-name-mappings");

            this.$allEventsCheckbox.change(function() {
                self.$explicitEventCheckboxes.prop("checked", $(this).is(":checked"));
            });
            this.$explicitEventCheckboxes.change(function() {
                if (!$(this).is(":checked")) {
                    self.$allEventsCheckbox.prop("checked", false);
                } else {
                    if (self.$explicitEventCheckboxes.filter(":not(:checked)").length === 0) {
                        self.$allEventsCheckbox.prop("checked", true);
                    }
                }
            });

            var transitionCollection = new TransitionCollection({selectionModel: selectionModel});
            new TransitionsView({model: transitionCollection});
        },
        getFormattedDateTime: function(dateTime) {
            return moment(dateTime).format(JIRA.translateSimpleDateFormat(AJS.Meta.get("date-complete")));
        },
        render: function() {
            var self = this;
            if (this.selectedModel) {
                var trimmedJql = AJS.$.trim(this.selectedModel.get("filter"));
                this.$jql.val(this.selectedModel.get("filter")); //.trigger('refreshInputHeight').trigger('webhooks.valueChanged');
                this.$jqlDisplay.text(trimmedJql || AJS.I18n.getText('webhooks.admin.jql.empty'));
                this.$jqlOverlabel.toggleClass("hidden", !!trimmedJql);

                this.$excludeDetails.prop("checked", this.selectedModel.get("excludeIssueDetails"))
                var excludeDetailsDisplayText = this.selectedModel.get("excludeIssueDetails") ? AJS.I18n.getText('common.words.yes') : AJS.I18n.getText('common.words.no');
                this.$excludeDetailsDisplay.text(excludeDetailsDisplayText);

                var events = this.selectedModel.get("events");
                if (events.length == 0) {
                    this.$allEventsCheckbox.prop("checked", false);
                    this.$explicitEventCheckboxes.prop("checked", false);
                    this.$eventsList.empty().append(TEMPLATES.noEvents());
                } else {
                    this.$allEventsCheckbox.prop("checked", events.length == ALL_EVENTS.length);
                    this.$explicitEventCheckboxes.each(function (){
                        var $checkbox = $(this);
                        $checkbox.prop("checked", _.indexOf(events, $checkbox.val()) != -1);
                    });
                    this.$eventsList.empty().append(TEMPLATES.eventList({
                        events: _.filter(_.map(events, function(event) {
                            return EVENT_MAPPING[event];
                        }), function(event) {
                            return event !== undefined;
                        })
                    }));

                }
            }
        },
        getParameters: function() {
            this.selectedModel.unset("filter", { silent: true });
            this.selectedModel.unset("excludeIssueDetails", { silent: true });
            return {
                filter: this.$jql.val(),
                excludeIssueDetails: $("#webhook-exclude-details").is(":checked")
            };
        },
        getEvents: function() {
            return this.$explicitEventsContainer.find("input:checked").map(function () { return AJS.$(this).val()}).toArray();
        },
        reset: function() {
            this.$explicitEventsList.find("input:checkbox").each(function() {
                $(this).prop("checked", false);
            });
            $("#webhook-exclude-details").prop("checked", false);
        },
        submitSuccess: function(model, response) {
            model.set("parameters", model.get("parameters"));
        },
        submitError: function(model, response) {
            try {
                var errorObject = JSON.parse(response.responseText);
            } catch (parseError) {
                errorObject = {};
            }
            if (response.status === 400) {
                var that = this;
                var fieldErrors = errorObject.messages || {};
                _.each(fieldErrors, function(error, index) {
                    that.$el.find("#webhook-" + error.key).siblings(".error").text(error.arguments[0]);
                });
            }
        }
    });

    $(function () {
        $("#webhook-help-data").children().appendTo(".webhooks .toolbar-split-right .toolbar-group");
    });
})(AJS.$);
