/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.plugins.webhooks.mapper.IssueBeanFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransitionMapper {
    private final IssueBeanFactory issueBeanFactory;
    private final UserBeanFactory userBeanFactory;
    private static final Logger LOG = Logger.getLogger((String)TransitionMapper.class.getName());

    public TransitionMapper(IssueBeanFactory issueBeanFactory, UserBeanFactory userBeanFactory) {
        this.issueBeanFactory = issueBeanFactory;
        this.userBeanFactory = userBeanFactory;
    }

    public Map<String, Object> toMap(Map transientVars, User user, MutableIssue issue) {
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        ImmutableMap.Builder transition = ImmutableMap.builder();
        Integer actionId = (Integer)transientVars.get("actionId");
        WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)transientVars.get("descriptor");
        ActionDescriptor actionDescriptor = workflowDescriptor.getAction(actionId.intValue());
        Step createdStep = (Step)transientVars.get("createdStep");
        WorkflowStore workflowStore = (WorkflowStore)transientVars.get("store");
        transition.put((Object)"workflowId", (Object)entry.getId()).put((Object)"workflowName", (Object)entry.getWorkflowName()).put((Object)"transitionId", (Object)actionId).put((Object)"transitionName", (Object)actionDescriptor.getName()).put((Object)"from_status", (Object)this.findPreviousStatus(createdStep, entry, workflowStore, workflowDescriptor)).put((Object)"to_status", (Object)createdStep.getStatus());
        ImmutableMap.Builder transitionContext = ImmutableMap.builder();
        transitionContext.put((Object)"transition", (Object)transition.build()).put((Object)"comment", transientVars.get("comment") != null ? transientVars.get("comment") : "").put((Object)"user", user != null ? this.userBeanFactory.createBean(user) : "");
        transitionContext.put((Object)"issue", (Object)this.issueBeanFactory.createBean((Issue)issue));
        transitionContext.put((Object)"timestamp", (Object)createdStep.getStartDate().getTime());
        return transitionContext.build();
    }

    private String findPreviousStatus(Step currentStep, WorkflowEntry entry, WorkflowStore workflowStore, WorkflowDescriptor workflowDescriptor) {
        if (currentStep.getPreviousStepIds().length == 0) {
            return "";
        }
        final long previousStepId = currentStep.getPreviousStepIds()[0];
        try {
            List historySteps = workflowStore.findHistorySteps(entry.getId());
            Step previousStep = (Step)Iterables.find((Iterable)historySteps, (Predicate)new Predicate<Step>(){

                public boolean apply(Step step) {
                    return step.getId() == previousStepId;
                }
            }, null);
            if (previousStep == null) {
                LOG.error((Object)"Transition from cannot be found. It seems that workflow data is inconsistent.");
                return "";
            }
            return workflowDescriptor.getStep(previousStep.getStepId()).getName();
        }
        catch (StoreException e) {
            return "";
        }
    }
}

