/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class Task001
implements PluginUpgradeTask {
    private ActiveObjects ao;
    private final ImmutableMap<String, WebHookJiraEvent> eventRenameMap;

    public Task001(ActiveObjects ao) {
        this.ao = ao;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"issue_created", (Object)WebHookJiraEvent.ISSUE_CREATED);
        builder.put((Object)"issue_deleted", (Object)WebHookJiraEvent.ISSUE_DELETED);
        builder.put((Object)"issue_work_logged", (Object)WebHookJiraEvent.WORKLOG_UPDATED);
        builder.put((Object)"issue_worklog_deleted", (Object)WebHookJiraEvent.WORKLOG_UPDATED);
        builder.put((Object)"issue_worklog_updated", (Object)WebHookJiraEvent.WORKLOG_UPDATED);
        builder.put((Object)"issue_assigned", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_closed", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_reopened", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_resolved", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_comment_edited", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_commented", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_moved", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_updated", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_work_started", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_work_stopped", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        builder.put((Object)"issue_generic_event", (Object)WebHookJiraEvent.ISSUE_UPDATED);
        this.eventRenameMap = builder.build();
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "This upgrade tasks consolidates the old LOTS OF EVENTS into a smaller, more understandable number.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        WebhookDao[] webhookDaos;
        for (WebhookDao webhookDao : webhookDaos = (WebhookDao[])this.ao.find(WebhookDao.class)) {
            String[] events;
            HashSet<String> eventSet = new HashSet<String>();
            for (String event : events = webhookDao.getEvents()) {
                if (this.eventRenameMap.containsKey((Object)event)) {
                    eventSet.add(((WebHookJiraEvent)((Object)this.eventRenameMap.get((Object)event))).getValue());
                    continue;
                }
                eventSet.add(event);
            }
            webhookDao.setEvents(eventSet.toArray(new String[eventSet.size()]));
            webhookDao.save();
        }
        return Collections.emptyList();
    }

    public String getPluginKey() {
        return "com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin";
    }
}

