/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.store;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.jira.plugins.webhooks.listener.JiraWebHookListenerParameters;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webhooks.spi.provider.WebHookListenerParameters;
import com.atlassian.webhooks.spi.provider.store.WebHookListenerStore;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.json.JSONObject;

public class JiraWebHookListenerStore
implements WebHookListenerStore {
    private final ActiveObjects ao;
    private final UserManager userManager;
    private final I18nResolver i18n;

    public JiraWebHookListenerStore(ActiveObjects ao, UserManager userManager, I18nResolver i18n) {
        this.i18n = (I18nResolver)Preconditions.checkNotNull((Object)i18n);
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    public WebHookListenerParameters addWebHook(final String name, final String targetUrl, final Iterable<String> events, final Map<String, String> params, final String registrationMethod) {
        WebhookDao webhookDao = (WebhookDao)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebhookDao>(){

            public WebhookDao doInTransaction() {
                Optional<String> filter = JiraWebHookListenerParameters.ParametersParser.getFilter(params);
                WebhookDao webHookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.create(WebhookDao.class, new DBParam[]{new DBParam("LAST_UPDATED_USER", (Object)JiraWebHookListenerStore.this.userManager.getRemoteUsername()), new DBParam("URL", (Object)targetUrl), new DBParam("LAST_UPDATED", (Object)new Date()), new DBParam("NAME", (Object)name), new DBParam("FILTER", (Object)(filter.isPresent() ? (String)filter.get() : "")), new DBParam("REGISTRATION_METHOD", (Object)registrationMethod), new DBParam("ENABLED", (Object)true), new DBParam("EXCLUDE_ISSUE_DETAILS", (Object)JiraWebHookListenerParameters.ParametersParser.getExcludeIssueDetails(params)), new DBParam("PARAMETERS", (Object)JiraWebHookListenerParameters.ParametersParser.getRemainingParameters(params))});
                webHookDao.setEvents((String[])Iterables.toArray((Iterable)events, String.class));
                webHookDao.save();
                return webHookDao;
            }
        });
        return this.createWebHookListenerParameters(webhookDao);
    }

    public WebHookListenerParameters updateWebHook(final int id, final String name, final String targetUrl, final Iterable<String> events, final Map<String, String> params, final boolean enabled) throws IllegalArgumentException {
        return this.createWebHookListenerParameters((WebhookDao)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebhookDao>(){

            public WebhookDao doInTransaction() {
                WebhookDao webHookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, (Object)id);
                if (webHookDao == null) {
                    throw new IllegalArgumentException(JiraWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                Optional<String> filter = JiraWebHookListenerParameters.ParametersParser.getFilter(params);
                webHookDao.setName(name);
                webHookDao.setUrl(targetUrl);
                webHookDao.setEvents((String[])Iterables.toArray((Iterable)events, String.class));
                webHookDao.setFilter(filter.isPresent() ? (String)filter.get() : "");
                webHookDao.setExcludeIssueDetails(JiraWebHookListenerParameters.ParametersParser.getExcludeIssueDetails(params));
                webHookDao.setEnabled(enabled);
                webHookDao.setLastUpdatedUser(JiraWebHookListenerStore.this.userManager.getRemoteUsername());
                webHookDao.setLastUpdated(new Date());
                webHookDao.setParameters(new JSONObject(params).toString());
                webHookDao.save();
                return webHookDao;
            }
        }));
    }

    public Optional<WebHookListenerParameters> getWebHook(final int id) {
        return (Optional)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Optional<WebHookListenerParameters>>(){

            public Optional<WebHookListenerParameters> doInTransaction() {
                return Optional.fromNullable((Object)JiraWebHookListenerStore.this.createWebHookListenerParameters((WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, (Object)id)));
            }
        });
    }

    public void removeWebHook(final int id) throws IllegalArgumentException {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                WebhookDao webHookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, (Object)id);
                if (webHookDao == null) {
                    throw new IllegalArgumentException(JiraWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                JiraWebHookListenerStore.this.ao.delete(new RawEntity[]{webHookDao});
                return webHookDao;
            }
        });
    }

    public Collection<WebHookListenerParameters> getAllWebHooks() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)((Iterable)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Collection<WebhookDao>>(){

            public Collection<WebhookDao> doInTransaction() {
                return Arrays.asList(JiraWebHookListenerStore.this.ao.find(WebhookDao.class));
            }
        })), (Function)new Function<WebhookDao, WebHookListenerParameters>(){

            public WebHookListenerParameters apply(WebhookDao webhookDao) {
                return JiraWebHookListenerStore.this.createWebHookListenerParameters(webhookDao);
            }
        }));
    }

    public Optional<WebHookListenerParameters> enableWebHook(final int id, final boolean enabled) {
        WebhookDao updatedWebHookListener = (WebhookDao)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebhookDao>(){

            public WebhookDao doInTransaction() {
                WebhookDao webhookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, (Object)id);
                if (webhookDao == null) {
                    throw new IllegalArgumentException(JiraWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                webhookDao.setEnabled(enabled);
                webhookDao.setLastUpdated(new Date());
                webhookDao.setLastUpdatedUser(JiraWebHookListenerStore.this.userManager.getRemoteUsername());
                webhookDao.save();
                return webhookDao;
            }
        });
        return Optional.of((Object)this.createWebHookListenerParameters(updatedWebHookListener));
    }

    private WebHookListenerParameters createWebHookListenerParameters(WebhookDao webhookDao) {
        return new WebHookListenerParameters.WebHookListenerParametersImpl(webhookDao.getID(), Boolean.valueOf(webhookDao.isEnabled()), webhookDao.getLastUpdated(), webhookDao.getLastUpdatedUser(), webhookDao.getName(), webhookDao.getUrl(), JiraWebHookListenerParameters.ParametersBuilder.buildParameters(webhookDao.getFilter(), webhookDao.getExcludeIssueDetails(), webhookDao.getParameters()), (Iterable)Lists.newArrayList((Object[])webhookDao.getEvents()), webhookDao.getRegistrationMethod());
    }
}

