/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.rest;

import com.atlassian.jira.plugins.webhooks.workflow.WorkflowUtil;
import com.atlassian.webhooks.api.provider.WebHookListenerService;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="jira-webhook")
public class JiraWebHookResource {
    private final WebHookListenerService webHookListenerService;
    private final WorkflowUtil workflowUtil;

    public JiraWebHookResource(WebHookListenerService webHookListenerService, WorkflowUtil workflowUtil) {
        this.workflowUtil = (WorkflowUtil)Preconditions.checkNotNull((Object)workflowUtil);
        this.webHookListenerService = (WebHookListenerService)Preconditions.checkNotNull((Object)webHookListenerService);
    }

    @GET
    @Path(value="{id}/transitions")
    public Response getTransitions(@PathParam(value="id") int id) {
        Optional webHookListener = this.webHookListenerService.getWebHookListener(Integer.valueOf(id));
        if (!webHookListener.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.workflowUtil.getTransitionLinkedToWebHookListener(id)).build();
    }
}

