/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.matcher;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.plugins.webhooks.matcher.IssueEventClassMatcher;
import com.atlassian.jira.plugins.webhooks.matcher.IssueEventIdMatcher;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;

public enum WebHookJiraEvent {
    ISSUE_CREATED("jira:issue_created", "Issue Created", Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_CREATED_ID})),
    ISSUE_DELETED("jira:issue_deleted", "Issue Deleted", IssuePreDeleteEvent.class),
    ISSUE_UPDATED("jira:issue_updated", "Issue Updated", Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_ASSIGNED_ID, EventType.ISSUE_CLOSED_ID, EventType.ISSUE_REOPENED_ID, EventType.ISSUE_RESOLVED_ID, EventType.ISSUE_COMMENT_EDITED_ID, EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_MOVED_ID, EventType.ISSUE_UPDATED_ID, EventType.ISSUE_WORKSTARTED_ID, EventType.ISSUE_WORKSTOPPED_ID, EventType.ISSUE_GENERICEVENT_ID})),
    WORKLOG_UPDATED("jira:worklog_updated", "Worklog Updated", Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_WORKLOG_UPDATED_ID, EventType.ISSUE_WORKLOG_DELETED_ID, EventType.ISSUE_WORKLOGGED_ID}));

    private String value;
    private String displayName;
    private EventMatcher<Object> jiraEventMatcher;
    private Class<? extends JiraEvent> eventClass;
    private Set<Long> issueEventIds;

    public String getValue() {
        return this.value;
    }

    public EventMatcher<Object> getJiraEventMatcher() {
        return this.jiraEventMatcher;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Class<? extends JiraEvent> getEventClass() {
        return this.eventClass;
    }

    public Set<Long> getIssueEventIds() {
        return this.issueEventIds;
    }

    private WebHookJiraEvent(String value, String displayName, Set<Long> issueEventIds) {
        this(value, displayName, new IssueEventIdMatcher(issueEventIds), IssueEvent.class);
        this.issueEventIds = issueEventIds;
    }

    private WebHookJiraEvent(String value, String displayName, Class<? extends JiraEvent> eventClass) {
        this(value, displayName, new IssueEventClassMatcher(eventClass), eventClass);
    }

    private WebHookJiraEvent(String value, String displayName, EventMatcher<Object> jiraEventMatcher, Class<? extends JiraEvent> eventClass) {
        this.value = value;
        this.displayName = displayName;
        this.jiraEventMatcher = jiraEventMatcher;
        this.eventClass = eventClass;
    }

    public static Optional<WebHookJiraEvent> forEventName(final String eventName) {
        return Optional.fromNullable((Object)Iterables.find(Arrays.asList(WebHookJiraEvent.values()), (Predicate)new Predicate<WebHookJiraEvent>(){

            public boolean apply(WebHookJiraEvent event) {
                return event.getValue().equals(eventName);
            }
        }, null));
    }
}

