/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.mapper;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.plugins.webhooks.listener.JiraWebHookListenerParameters;
import com.atlassian.jira.plugins.webhooks.mapper.EventMapper;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class EventTypeInfoDecorator
implements EventMapper<JiraEvent> {
    private final EventMapper<JiraEvent> mapper;
    private final Iterable<WebHookJiraEvent> jiraEvents;

    public EventTypeInfoDecorator(EventMapper<JiraEvent> mapper, Iterable<WebHookJiraEvent> jiraEvents) {
        this.mapper = mapper;
        this.jiraEvents = jiraEvents;
    }

    @Override
    public boolean handles(JiraEvent e) {
        return this.mapper.handles(e);
    }

    private WebHookJiraEvent getJiraEventMapping(JiraEvent e) {
        for (WebHookJiraEvent webhooksJiraEvent : this.jiraEvents) {
            if (!webhooksJiraEvent.getJiraEventMatcher().matches((Object)e, (Object)JiraWebHookListenerParameters.allSupportedEventConsumer())) continue;
            return webhooksJiraEvent;
        }
        throw new NoSuchElementException("No matching WebHookJiraEvent found for event " + e);
    }

    @Override
    public Map<String, Object> toMap(JiraEvent e) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String eventName = this.getJiraEventMapping(e).getValue();
        builder.put((Object)"webhookEvent", (Object)eventName);
        builder.putAll(this.mapper.toMap(e));
        return builder.build();
    }
}

