/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.listener;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.webhooks.spi.provider.WebHookListenerParameters;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class JiraWebHookListenerParameters {
    public static final String FILTER = "filter";
    public static final String EXCLUDE_ISSUE_DETAILS = "excludeIssueDetails";
    private final int consumerId;
    private final Optional<String> filter;
    private final Set<Long> eventIds;
    private final Set<Class<? extends JiraEvent>> eventClasses;
    private final boolean excludeIssueDetails;
    private static final Supplier<JiraWebHookListenerParameters> ALL_SUPPORTED_EVENTS_CONSUMER_PARAMS_SUPPLIER = Suppliers.memoize((Supplier)new Supplier<JiraWebHookListenerParameters>(){

        public JiraWebHookListenerParameters get() {
            HashSet<Long> eventIds = new HashSet<Long>();
            HashSet<Class<? extends JiraEvent>> eventClasses = new HashSet<Class<? extends JiraEvent>>();
            for (WebHookJiraEvent event : WebHookJiraEvent.values()) {
                if (event.getIssueEventIds() != null) {
                    eventIds.addAll(event.getIssueEventIds());
                }
                eventClasses.add(event.getEventClass());
            }
            return new JiraWebHookListenerParameters(0, null, eventIds, eventClasses, false);
        }
    });

    public JiraWebHookListenerParameters(int consumerId, Optional<String> filter, Set<Long> eventIds, Set<Class<? extends JiraEvent>> eventClasses, boolean excludeIssueDetails) {
        this.consumerId = consumerId;
        this.eventIds = eventIds;
        this.filter = filter;
        this.eventClasses = eventClasses;
        this.excludeIssueDetails = excludeIssueDetails;
    }

    public static Optional<JiraWebHookListenerParameters> createConsumerParams(WebHookListenerParameters webHookListenerParameters) {
        HashSet<Long> eventIds = new HashSet<Long>();
        HashSet<Class<? extends JiraEvent>> eventClasses = new HashSet<Class<? extends JiraEvent>>();
        for (String webHookEventName : webHookListenerParameters.getEvents()) {
            Optional<WebHookJiraEvent> jiraEvent = WebHookJiraEvent.forEventName(webHookEventName);
            if (!jiraEvent.isPresent()) {
                return Optional.absent();
            }
            if (((WebHookJiraEvent)((Object)jiraEvent.get())).getIssueEventIds() != null) {
                eventIds.addAll(((WebHookJiraEvent)((Object)jiraEvent.get())).getIssueEventIds());
            }
            eventClasses.add(((WebHookJiraEvent)((Object)jiraEvent.get())).getEventClass());
        }
        return Optional.of((Object)new JiraWebHookListenerParameters(webHookListenerParameters.getId(), ParametersParser.getFilter(webHookListenerParameters.getParameters()), eventIds, eventClasses, ParametersParser.getExcludeIssueDetails(webHookListenerParameters.getParameters())));
    }

    public static JiraWebHookListenerParameters allSupportedEventConsumer() {
        return (JiraWebHookListenerParameters)ALL_SUPPORTED_EVENTS_CONSUMER_PARAMS_SUPPLIER.get();
    }

    public Optional<String> getFilter() {
        return this.filter;
    }

    public Set<Long> getEventIds() {
        return this.eventIds;
    }

    public Set<Class<? extends JiraEvent>> getEventClasses() {
        return this.eventClasses;
    }

    public boolean isExcludeIssueDetails() {
        return this.excludeIssueDetails;
    }

    public int getConsumerId() {
        return this.consumerId;
    }

    public static Map<String, String> parametersWithoutExcludeAndFilter(Map<String, String> parameters) {
        return Maps.filterKeys(parameters, (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !key.equalsIgnoreCase(JiraWebHookListenerParameters.FILTER) && !key.equalsIgnoreCase(JiraWebHookListenerParameters.EXCLUDE_ISSUE_DETAILS);
            }
        });
    }

    public static class ParametersBuilder {
        public static Map<String, String> buildParameters(@Nullable String jqlFilter, boolean excludeIssueDetails, @Nullable String parameters) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)JiraWebHookListenerParameters.EXCLUDE_ISSUE_DETAILS, (Object)String.valueOf(excludeIssueDetails));
            if (jqlFilter != null) {
                builder.put((Object)JiraWebHookListenerParameters.FILTER, (Object)jqlFilter);
            }
            try {
                if (parameters != null) {
                    JSONObject jsonObject = new JSONObject(parameters);
                    HashMap<String, String> remainingParameters = new HashMap<String, String>();
                    if (jsonObject.length() > 0) {
                        for (String key : JSONObject.getNames((JSONObject)jsonObject)) {
                            remainingParameters.put(key, jsonObject.getString(key));
                        }
                    }
                    builder.putAll(JiraWebHookListenerParameters.parametersWithoutExcludeAndFilter(remainingParameters));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return builder.build();
        }
    }

    public static class ParametersParser {
        public static Boolean getExcludeIssueDetails(Map<String, String> parameters) {
            return (Boolean)Objects.firstNonNull((Object)Boolean.parseBoolean(parameters.get(JiraWebHookListenerParameters.EXCLUDE_ISSUE_DETAILS)), (Object)false);
        }

        public static Optional<String> getFilter(Map<String, String> parameters) {
            return Optional.fromNullable((Object)parameters.get(JiraWebHookListenerParameters.FILTER));
        }

        public static String getRemainingParameters(Map<String, String> parameters) {
            return new JSONObject(parameters).toString();
        }
    }
}

