(function() {
    JPT.DialogViewImpl = Backbone.View.extend({
        events: {
            "click   .add-project-trigger": "_onClickAddProject",
            "click   #add-project-dialog .import-project-trigger": "_onClickImportProject",
            "keydown #add-project-dialog .pt-templates-list": "_onKeydownInTemplatesList"
        },

        draw: function() {
            var dialog = new AJS.Dialog({
                width: 840,
                height: 400,
                id: "add-project-dialog",
                closeOnOutsideClick: false,
                keypressListener: _.bind(this._onKeyPressed, this)
            });

            var $dialog = dialog.popup.element;

            dialog.addPage("project-templates-page");

            dialog.addHeader(AJS.I18n.getText("add.project.select.template.title"), "add-project-dialog-header");

            dialog.addPanel("ProjectTemplatesListPanel", JIRA.Templates.ProjectTemplates.loadingTemplatesList(), "pt-content");

            this._dialog = dialog;
            this._$dialogElement = $dialog;

            dialog.show();

            return dialog;
        },

        /**
         * Removes this DialogView.
         *
         * @return {*}
         */
        remove: function() {
            this._dialog && this._dialog.remove();
        },

        showErrorMessage: function(message) {
            this._dialog.getPanel(1, 0).html(JIRA.Templates.errorMsg({
                closable: false,
                msg: message
            }));
        },

        get$PTContent: function getPTContent() {
            return JPT.DialogController.$dialogElement.find(".pt-content");
        },

        /**
         * Removes this dialog when ESC is pressed. Note that this is called on keydown anywhere within the dialog,
         * including all steps of the wizard, so you want to be careful about what you do in here.
         *
         * @param {jQuery.Event} e the keydown Event
         * @returns {boolean}
         * @private
         */
        _onKeyPressed: function(e) {
            var escapeKey = 27;
            if (this._dialog) {
                if (e.keyCode === escapeKey) {
                    JPT.DialogController.hideDialogFromNewUser("dismissed");
                    this._dialog.remove();
                    return false; // preventDefault, don't propagate.
                }
            }

            return true;
        },

        /**
         * Proceeds to the next step of the wizard when the user presses ENTER in the project templates list.
         * Unfortunately in this case we can't rely on browser auto-submit of forms because the focus is not inside a
         * text input/
         *
         * @param {jQuery.Event} e
         * @returns {boolean}
         * @private
         */
        _onKeydownInTemplatesList: function(e) {
            var enterKey = 13;
            if (this._dialog) {
                if (e.keyCode === enterKey) {
                    this._$dialogElement.find(".pt-submit-button:visible").click();
                    return false;
                }
            }

            return true;
        },

        _onClickAddProject: function(event) {
            event.preventDefault();
            JPT.DialogController.handleProjectTemplateTriggered();
        },

        _onClickImportProject: function(event) {
            JPT.DialogController.hideDialogFromNewUser("importproject");
        }
    });

    // create the JPT.DialogView global variable
    JPT.DialogView = new JPT.DialogViewImpl({ el: AJS.$(document) });

})();
