AJS.test.require("com.atlassian.jira.project-templates-plugin:test-resources");

module("JPT.DialogController", {
    setup: function() {
        this.metaGet = sinon.stub(AJS.Meta, "get");
        this.jQueryAjax = sinon.spy(jQuery, "ajax");
    },

    teardown: function() {
        this.metaGet.restore();
        this.jQueryAjax.restore();
    }
});

test("Dialog hidden from new user", function() {
    var dismissalReason = "test";
    this.metaGet.withArgs('show-welcome-screen').returns(true);

    JPT.DialogController.hideDialogFromNewUser(dismissalReason);
    var ajaxConfig = this.jQueryAjax.getCall(0).args[0];
    ok(ajaxConfig.url === AJS.contextPath() + "/rest/welcome/1.0/show/welcome/" + dismissalReason, "Correct 'hide' url");
    ok(ajaxConfig.type === "DELETE", "Correct http verb to hide dialog");
});
