/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.Validate;

@XmlRootElement
public class ProjectTemplateDialogData {
    @XmlElement
    public List<ProjectTemplate> projectTemplates;
    @XmlElement
    public Integer maxNameLength;
    @XmlElement
    public Integer minNameLength;
    @XmlElement
    public Integer maxKeyLength;
    @XmlElement
    public Boolean shouldShowProjectLead;
    @XmlElement
    public String serverId;
    @XmlElement
    public String currentUserDisplayName;
    @XmlElement
    public String currentUserName;
    @XmlElement
    public String currentUserAvatarUrl;
    @XmlElement
    public Long projectCount;

    public ProjectTemplateDialogData(List<ProjectTemplate> projectTemplateDescriptions, Integer maxNameLength, Integer maxKeyLength, Integer minNameLength, Boolean shouldShowProjectLead, String serverId, String currentUserName, String currentUserDisplayName, String currentUserAvatarUrl, Long projectCount) {
        this.projectTemplates = projectTemplateDescriptions;
        this.maxNameLength = maxNameLength;
        this.minNameLength = minNameLength;
        this.maxKeyLength = maxKeyLength;
        this.shouldShowProjectLead = shouldShowProjectLead;
        this.serverId = serverId;
        this.currentUserName = currentUserName;
        this.currentUserDisplayName = currentUserDisplayName;
        this.currentUserAvatarUrl = currentUserAvatarUrl;
        this.projectCount = projectCount;
    }

    public ProjectTemplateDialogData() {
    }

    public static class Builder {
        private List<ProjectTemplate> projectTemplateDescriptions = null;
        private Integer maxNameLength = null;
        private Integer minNameLength = null;
        private Integer maxKeyLength = null;
        private Boolean shouldShowProjectLead = null;
        private String serverId = null;
        public String currentUserName = null;
        public String currentUserDisplayName = null;
        public String currentUserAvatarUrl = null;
        public Long projectCount = null;

        public ProjectTemplateDialogData build() {
            Validate.notNull(this.projectTemplateDescriptions);
            Validate.notNull((Object)this.maxNameLength);
            Validate.notNull((Object)this.minNameLength);
            Validate.notNull((Object)this.maxKeyLength);
            Validate.notNull((Object)this.shouldShowProjectLead);
            Validate.notNull((Object)this.serverId);
            Validate.notNull((Object)this.currentUserName);
            Validate.notNull((Object)this.currentUserDisplayName);
            Validate.notNull((Object)this.currentUserAvatarUrl);
            Validate.notNull((Object)this.projectCount);
            return new ProjectTemplateDialogData(this.projectTemplateDescriptions, this.maxNameLength, this.maxKeyLength, this.minNameLength, this.shouldShowProjectLead, this.serverId, this.currentUserName, this.currentUserDisplayName, this.currentUserAvatarUrl, this.projectCount);
        }

        public Builder projectTemplates(List<ProjectTemplate> projectTemplateDescriptions) {
            this.projectTemplateDescriptions = projectTemplateDescriptions;
            return this;
        }

        public Builder maxNameLength(Integer maxNameLength) {
            this.maxNameLength = maxNameLength;
            return this;
        }

        public Builder minNameLength(Integer minNameLength) {
            this.minNameLength = minNameLength;
            return this;
        }

        public Builder maxKeyLength(Integer maxKeyLength) {
            this.maxKeyLength = maxKeyLength;
            return this;
        }

        public Builder shouldShowProjectLead(Boolean shouldShowProjectLead) {
            this.shouldShowProjectLead = shouldShowProjectLead;
            return this;
        }

        public Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder currentUserName(String username) {
            this.currentUserName = username;
            return this;
        }

        public Builder currentUserDisplayName(String displayName) {
            this.currentUserDisplayName = displayName;
            return this;
        }

        public Builder currentUserAvatarUrl(String avatarUrl) {
            this.currentUserAvatarUrl = avatarUrl;
            return this;
        }

        public Builder projectCount(Long projectCount) {
            this.projectCount = projectCount;
            return this;
        }
    }
}

