/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.core;

import com.atlassian.jira.util.BuildUtilsInfo;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class QUnitFilter
implements Filter {
    private static final String INTERNAL_PATH_PREFIX = "/plugins/servlet/";
    private final BuildUtilsInfo buildUtilsInfo;
    private String externalPath;
    private String internalPath;
    private Pattern URLPattern;

    public QUnitFilter(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.externalPath = this.getExternalPath(filterConfig);
        this.internalPath = this.getInternalPath(filterConfig);
        this.URLPattern = Pattern.compile("^/?" + Pattern.quote(this.externalPath) + "/?(.*)?$");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            String URI2 = servletRequest.getRequestURI().substring(servletRequest.getContextPath().length());
            Matcher matcher = this.URLPattern.matcher(URI2);
            if (matcher.matches()) {
                String destination = "/qunit";
                if (this.buildUtilsInfo.getVersion().startsWith("6.0")) {
                    destination = this.internalPath + "/" + matcher.group(1);
                }
                request.setAttribute("externalPath", (Object)this.externalPath);
                request.getRequestDispatcher(destination).forward(request, response);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private String getExternalPath(FilterConfig filterConfig) {
        return StringUtils.strip((String)filterConfig.getInitParameter("externalPath"), (String)"/");
    }

    private String getInternalPath(FilterConfig filterConfig) {
        String internalPath = filterConfig.getInitParameter("internalPath");
        return INTERNAL_PATH_PREFIX + StringUtils.strip((String)internalPath, (String)"/");
    }
}

