/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.template;

import com.atlassian.jira.blueprint.template.WorkflowSchemeTemplate;
import com.atlassian.jira.blueprint.template.WorkflowTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public final class WorkflowSchemeTemplateImpl
implements WorkflowSchemeTemplate {
    private final String name;
    private final String description;
    private final String defaultWorkflow;
    private final List<WorkflowTemplate> workflowTemplates;

    public WorkflowSchemeTemplateImpl(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="default-workflow") String defaultWorkflow, @JsonProperty(value="workflows") List<? extends WorkflowTemplate> workflowTemplates) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.defaultWorkflow = defaultWorkflow == null ? null : defaultWorkflow.toUpperCase();
        Preconditions.checkNotNull(workflowTemplates, (Object)"workflowTemplates");
        this.workflowTemplates = Lists.newArrayList(workflowTemplates);
        this.validate();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String defaultWorkflow() {
        return this.defaultWorkflow;
    }

    @Override
    public List<WorkflowTemplate> workflowTemplates() {
        return Collections.unmodifiableList(this.workflowTemplates);
    }

    @Override
    public boolean hasWorkflow(String workflowKey) {
        for (WorkflowTemplate workflowTemplate : this.workflowTemplates) {
            if (!workflowTemplate.key().equalsIgnoreCase(workflowKey)) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        this.validateDefaultWorkflow();
    }

    private void validateDefaultWorkflow() {
        if (Strings.isNullOrEmpty((String)this.defaultWorkflow)) {
            return;
        }
        boolean defaultWorkflowExists = false;
        for (WorkflowTemplate wfTemplate : this.workflowTemplates) {
            if (!wfTemplate.key().equals(this.defaultWorkflow)) continue;
            defaultWorkflowExists = true;
        }
        if (!defaultWorkflowExists) {
            throw new IllegalArgumentException("Default workflow '" + this.defaultWorkflow + "' of workflow scheme '" + this.name + "' does not exist.");
        }
    }
}

