/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.descriptor;

import com.atlassian.fugue.Option;
import com.atlassian.jira.blueprint.descriptor.PluginParseHelper;
import com.atlassian.plugin.PluginParseException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

class DefaultPluginParseHelper
implements PluginParseHelper {
    private final Element element;
    private final String xpath;

    public DefaultPluginParseHelper(Element element, String xpath) {
        this.element = element;
        this.xpath = xpath;
    }

    @Override
    public PluginParseHelper element(String name) {
        return this.element(name, true);
    }

    @Override
    public Option<PluginParseHelper> optElement(String name) {
        return Option.option((Object)this.element(name, false));
    }

    @Override
    public String attribute(String name) {
        return this.attribute(name, true);
    }

    @Override
    public String optAttribute(String name) {
        return this.attribute(name, false);
    }

    @Override
    public String text() {
        return this.element.getText();
    }

    @Override
    public Element rawElement() {
        return this.element;
    }

    private PluginParseHelper element(String name, boolean required) {
        String xpath = String.format("%s/%s", this.xpath, name);
        Node node = this.element.selectSingleNode(xpath);
        if (node == null) {
            if (required) {
                throw new PluginParseException("Missing expected node: " + xpath);
            }
            return null;
        }
        if (node instanceof Element) {
            return new DefaultPluginParseHelper((Element)node, xpath);
        }
        throw new PluginParseException(String.format("Got %s at %s when expecting an Element", node.getClass(), xpath));
    }

    private String attribute(String name, boolean required) {
        Attribute attribute = this.element.attribute(name);
        if (attribute == null) {
            if (required) {
                throw new PluginParseException(String.format("Missing expected attribute %s at: %s", name, this.xpath));
            }
            return null;
        }
        return attribute.getText();
    }
}

