/**
 * Holds the recommendations of a particular category
 * In future will become a paginated collection supporting infinite scroll
 */
define('jira/optimizer-plugin/recommendationsCollection', ['jira-optimizer-plugin/backbone-paginator', 'wrm/context-path', 'jira/optimizer-plugin/recommendationModel'], function (PageableCollection, contextPath, RecommendationModel) {
    'use strict';

    var RECOMMENDATIONS_URL = '/rest/optimizer/1/recommendations';

    return PageableCollection.extend({
        model: RecommendationModel,
        initialize: function initialize(models, options) {
            this.category = options.category;
        },

        url: contextPath() + RECOMMENDATIONS_URL,
        state: {
            pageSize: 25
        },
        queryParams: {
            currentPage: 'startAt',
            pageSize: 'maxResults',
            category: function category() {
                return this.category;
            }
        },
        parseRecords: function parseRecords(resp, options) {
            return resp.values;
        },

        parseState: function parseState(resp) {
            return { totalRecords: resp.total };
        }
    });
});