/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Tree<T> {
    private final Node<T> root = new Node<Object>(null);
    private final Map<Object, Node<T>> map = new HashMap<Object, Node<T>>();
    private final List<DataWrap<T>> notMapped = new ArrayList<DataWrap<T>>();

    public Node<T> getRoot() {
        return this.root;
    }

    public void add(T data, Object id, Object parent) {
        this.notMapped.add(new DataWrap<T>(data, id, parent));
        this.tryMapping();
    }

    private void tryMapping() {
        int size = this.notMapped.size();
        Iterator<DataWrap<T>> iter = this.notMapped.iterator();
        while (iter.hasNext()) {
            Node n;
            DataWrap<T> next = iter.next();
            if (next.parent == null) {
                n = new Node(next.data);
                this.map.put(next.id, n);
                this.root.getChildren().add(n);
                iter.remove();
                continue;
            }
            if (!this.map.containsKey(next.parent)) continue;
            n = new Node(next.data);
            Node<T> node = this.map.get(next.parent);
            this.map.put(next.id, n);
            node.getChildren().add(n);
            iter.remove();
        }
        if (this.notMapped.size() < size) {
            this.tryMapping();
        }
    }

    private static class DataWrap<T> {
        final T data;
        final Object id;
        final Object parent;

        public DataWrap(T data, Object id, Object parent) {
            this.data = data;
            this.id = id;
            this.parent = parent;
        }
    }

    public static class Node<T> {
        private final T data;
        private final List<Node<T>> children;

        public Node(T data) {
            this(data, null);
        }

        public Node(T data, List<Node<T>> children) {
            this.data = data;
            this.children = children != null ? children : new ArrayList();
        }

        public T getData() {
            return this.data;
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }
    }
}

