/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model;

import java.util.Collection;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.transition.TransitionKind;

public class TransitionData<S, E> {
    private final S source;
    private final S target;
    private final S state;
    private final E event;
    private final Long period;
    private final Integer count;
    private final Collection<Action<S, E>> actions;
    private final Guard<S, E> guard;
    private final TransitionKind kind;
    private final SecurityRule securityRule;

    public TransitionData(S source, S target, E event) {
        this(source, target, null, event, null, null, (Collection<Action<Object, E>>)null, (Guard<Object, E>)null, TransitionKind.EXTERNAL, null);
    }

    public TransitionData(S source, S target, E event, Collection<Action<S, E>> actions, Guard<S, E> guard, TransitionKind kind) {
        this(source, target, null, event, null, null, (Collection<Action<Object, E>>)actions, (Guard<Object, E>)guard, kind, null);
    }

    public TransitionData(S source, S target, Long period, Integer count, Collection<Action<S, E>> actions, Guard<S, E> guard, TransitionKind kind) {
        this(source, target, null, null, period, count, (Collection<Action<Object, Object>>)actions, (Guard<Object, Object>)guard, kind, null);
    }

    public TransitionData(S source, S target, S state, E event, Long period, Integer count, Collection<Action<S, E>> actions, Guard<S, E> guard, TransitionKind kind, SecurityRule securityRule) {
        this.source = source;
        this.target = target;
        this.state = state;
        this.event = event;
        this.period = period;
        this.count = count;
        this.actions = actions;
        this.guard = guard;
        this.kind = kind;
        this.securityRule = securityRule;
    }

    public S getSource() {
        return this.source;
    }

    public S getTarget() {
        return this.target;
    }

    public S getState() {
        return this.state;
    }

    public E getEvent() {
        return this.event;
    }

    public Long getPeriod() {
        return this.period;
    }

    public Integer getCount() {
        return this.count;
    }

    public Collection<Action<S, E>> getActions() {
        return this.actions;
    }

    public Guard<S, E> getGuard() {
        return this.guard;
    }

    public TransitionKind getKind() {
        return this.kind;
    }

    public SecurityRule getSecurityRule() {
        return this.securityRule;
    }
}

