/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configuration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.ObjectStateMachineFactory;
import org.springframework.statemachine.config.StateMachineConfig;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.config.builders.StateMachineConfigBuilder;
import org.springframework.statemachine.config.common.annotation.AbstractImportingAnnotationConfiguration;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurer;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.util.ClassUtils;

@Configuration
public class StateMachineFactoryConfiguration<S, E>
extends AbstractImportingAnnotationConfiguration<StateMachineConfigBuilder<S, E>, StateMachineConfig<S, E>> {
    private final StateMachineConfigBuilder<S, E> builder = new StateMachineConfigBuilder();

    @Override
    protected BeanDefinition buildBeanDefinition(AnnotationMetadata importingClassMetadata, Class<? extends Annotation> namedAnnotation) throws Exception {
        String enableStateMachineEnclosingClassName = importingClassMetadata.getClassName();
        Class enableStateMachineEnclosingClass = ClassUtils.forName((String)enableStateMachineEnclosingClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(StateMachineFactoryDelegatingFactoryBean.class);
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableStateMachineFactory.class.getName(), false));
        Boolean contextEvents = attributes.getBoolean("contextEvents");
        beanDefinitionBuilder.addConstructorArgValue(this.builder);
        beanDefinitionBuilder.addConstructorArgValue((Object)importingClassMetadata.getClassName());
        beanDefinitionBuilder.addConstructorArgValue((Object)contextEvents);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
        ResolvableType type = this.resolveFactoryObjectType(enableStateMachineEnclosingClass);
        if (type != null && beanDefinition instanceof RootBeanDefinition) {
            ((RootBeanDefinition)beanDefinition).setTargetType(type);
        }
        return beanDefinition;
    }

    private ResolvableType resolveFactoryObjectType(Class<?> enableStateMachineEnclosingClass) {
        ResolvableType type = null;
        try {
            Class[] generics = ResolvableType.forClass(enableStateMachineEnclosingClass).getSuperType().resolveGenerics();
            if (generics != null && generics.length == 2) {
                type = ResolvableType.forClassWithGenerics(StateMachineFactory.class, (Class[])generics);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    @Override
    protected List<Class<? extends Annotation>> getAnnotations() {
        ArrayList<Class<? extends Annotation>> types = new ArrayList<Class<? extends Annotation>>();
        types.add(EnableStateMachineFactory.class);
        return types;
    }

    private static class StateMachineFactoryDelegatingFactoryBean<S, E>
    implements FactoryBean<StateMachineFactory<S, E>>,
    BeanFactoryAware,
    InitializingBean {
        private final StateMachineConfigBuilder<S, E> builder;
        private List<AnnotationConfigurer<StateMachineConfig<S, E>, StateMachineConfigBuilder<S, E>>> configurers;
        private BeanFactory beanFactory;
        private StateMachineFactory<S, E> stateMachineFactory;
        private String clazzName;
        private Boolean contextEvents;

        public StateMachineFactoryDelegatingFactoryBean(StateMachineConfigBuilder<S, E> builder, String clazzName, Boolean contextEvents) {
            this.builder = builder;
            this.clazzName = clazzName;
            this.contextEvents = contextEvents;
        }

        public StateMachineFactory<S, E> getObject() throws Exception {
            return this.stateMachineFactory;
        }

        public Class<?> getObjectType() {
            return StateMachineFactory.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void afterPropertiesSet() throws Exception {
            if (this.configurers == null || this.configurers.size() == 0) {
                throw new BeanDefinitionStoreException("Cannot configure state machine due to missing configurers. Did you remember to use @EnableStateMachineFactory with a StateMachineConfigurerAdapter.");
            }
            for (AnnotationConfigurer<StateMachineConfig<S, E>, StateMachineConfigBuilder<S, E>> configurer : this.configurers) {
                Class<?> clazz = configurer.getClass();
                if (!ClassUtils.getUserClass(clazz).getName().equals(this.clazzName)) continue;
                this.builder.apply(configurer);
            }
            StateMachineConfig stateMachineConfig = (StateMachineConfig)this.builder.getOrBuild();
            TransitionsData stateMachineTransitions = stateMachineConfig.getTransitions();
            StatesData stateMachineStates = stateMachineConfig.getStates();
            ConfigurationData stateMachineConfigurationConfig = stateMachineConfig.getStateMachineConfigurationConfig();
            ObjectStateMachineFactory objectStateMachineFactory = null;
            objectStateMachineFactory = stateMachineConfig.getModel() != null && stateMachineConfig.getModel().getFactory() != null ? new ObjectStateMachineFactory(new DefaultStateMachineModel(stateMachineConfigurationConfig, null, null), stateMachineConfig.getModel().getFactory()) : new ObjectStateMachineFactory(new DefaultStateMachineModel(stateMachineConfigurationConfig, stateMachineStates, stateMachineTransitions), null);
            objectStateMachineFactory.setBeanFactory(this.beanFactory);
            objectStateMachineFactory.setContextEventsEnabled(this.contextEvents);
            objectStateMachineFactory.setHandleAutostartup(true);
            this.stateMachineFactory = objectStateMachineFactory;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        @Autowired(required=false)
        protected void onConfigurers(List<AnnotationConfigurer<StateMachineConfig<S, E>, StateMachineConfigBuilder<S, E>>> configurers) throws Exception {
            this.configurers = configurers;
        }
    }
}

