/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl.recommendations;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.optimizer.impl.recommendations.CustomFieldsProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldsStatsProvider {
    private final CustomFieldManager customFieldManager;
    private final CustomFieldsProvider customFieldsProvider;

    @Inject
    public CustomFieldsStatsProvider(@ComponentImport CustomFieldManager customFieldManager, CustomFieldsProvider customFieldsProvider) {
        this.customFieldManager = customFieldManager;
        this.customFieldsProvider = customFieldsProvider;
    }

    public Map<String, Long> getStats() {
        return ImmutableMap.of((Object)"all", (Object)this.getCount(cf -> true), (Object)"localisable", (Object)this.getCount(this.customFieldsProvider::canBeLocalised), (Object)"allProjects", (Object)this.getCount(CustomField::isAllProjects), (Object)"allIssueTypes", (Object)this.getCount(CustomField::isAllIssueTypes), (Object)"allProjectsAndAllIssueTypes", (Object)this.getCount(((Predicate<CustomField>)CustomField::isAllProjects).and(CustomField::isAllIssueTypes)));
    }

    private long getCount(Predicate<CustomField> filter) {
        return this.customFieldManager.getCustomFieldObjects().stream().filter(filter).count();
    }
}

