/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl.actions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.optimizer.ao.RecommendationsDao;
import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.optimizer.events.RecommendationAppliedEvent;
import com.atlassian.jira.optimizer.impl.RecommendationsManager;
import com.atlassian.jira.optimizer.impl.actions.Action;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ActionManager {
    private static final Logger log = LoggerFactory.getLogger(ActionManager.class);
    private final Map<String, Action> actionMap;
    private final EventPublisher eventPublisher;
    private final RecommendationsManager recommendationsManager;
    private final I18nHelper i18nHelper;
    private final RecommendationsDao recommendationsDao;

    @Inject
    public ActionManager(@ComponentImport EventPublisher eventPublisher, @ComponentImport I18nHelper i18nHelper, List<Action> actions, RecommendationsManager recommendationsManager, RecommendationsDao recommendationsDao) {
        this.eventPublisher = eventPublisher;
        this.i18nHelper = i18nHelper;
        this.recommendationsManager = recommendationsManager;
        this.actionMap = actions.stream().collect(Collectors.toMap(Action::getRecommendationCategory, Function.identity()));
        this.recommendationsDao = recommendationsDao;
    }

    public void applyRecommendation(String recommendationId) {
        RecommendationBean recommendation = this.recommendationsManager.getRecommendation(recommendationId);
        try {
            Preconditions.checkArgument((recommendation != null ? 1 : 0) != 0, (Object)this.i18nHelper.getText("optimizer.plugin.change.not.valid"));
            Preconditions.checkArgument((!recommendation.isResolved() ? 1 : 0) != 0, (Object)this.i18nHelper.getText("optimizer.plugin.change.already.applied"));
            this.applyRecommendation(recommendation);
            this.eventPublisher.publish((Object)new RecommendationAppliedEvent(recommendation.getPerformanceImpact(), true));
        }
        catch (RuntimeException e) {
            this.eventPublisher.publish((Object)new RecommendationAppliedEvent(recommendation != null ? recommendation.getPerformanceImpact() : -1.0, false));
            throw e;
        }
    }

    private void applyRecommendation(RecommendationBean recommendation) {
        log.info("Applying recommendation {}", (Object)recommendation);
        Action action = this.actionMap.get(recommendation.getCategory());
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (String)"Error while applying recommendation '%s': Couldn't find an action for '%s' category", (Object)recommendation, (Object)recommendation.getCategory());
        action.applyRecommendation(recommendation);
        this.recommendationsDao.setResolved(recommendation.getId(), true);
        log.info("Recommendation {} was applied successfully", (Object)recommendation);
    }
}

