/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl;

import com.atlassian.jira.optimizer.ao.RecommendationsDao;
import com.atlassian.jira.optimizer.api.RecommendationProvider;
import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.util.thread.OffRequestThreadExecutor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RecommendationsManager {
    private static final Logger log = LoggerFactory.getLogger(RecommendationsManager.class);
    private final Executor executor;
    private final List<RecommendationProvider> providers;
    private final RecommendationsDao recommendationsDao;
    private volatile Runnable finishListener = () -> {};
    private volatile Runnable failListener = () -> {};
    @GuardedBy(value="hasFinishedAddingTasks")
    private final List<Future> tasksToBeCompleted;
    private final Semaphore hasFinishedAddingTasks;
    private final OffRequestThreadExecutor offRequestThreadExecutor;

    @Inject
    public RecommendationsManager(List<RecommendationProvider> providers, @ComponentImport OffRequestThreadExecutor offRequestThreadExecutor, @Qualifier(value="recommendationManagerExecutor") Executor executor, RecommendationsDao recommendationsDao) {
        this.providers = providers;
        this.recommendationsDao = recommendationsDao;
        this.executor = executor;
        this.tasksToBeCompleted = new ArrayList<Future>();
        this.hasFinishedAddingTasks = new Semaphore(1);
        this.offRequestThreadExecutor = offRequestThreadExecutor;
    }

    void stop() {
        try {
            this.hasFinishedAddingTasks.acquire();
        }
        catch (InterruptedException ignored) {
            return;
        }
        this.tasksToBeCompleted.forEach(future -> future.cancel(false));
        this.hasFinishedAddingTasks.release();
    }

    void submitJobs() {
        try {
            this.hasFinishedAddingTasks.acquire();
        }
        catch (InterruptedException ignored) {
            return;
        }
        this.recommendationsDao.removeAll();
        this.tasksToBeCompleted.clear();
        this.executor.execute(this::createJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getProgress() {
        if (this.hasFinishedAddingTasks.tryAcquire()) {
            try {
                double done = this.tasksToBeCompleted.stream().filter(Future::isDone).count();
                double d = done / (double)this.tasksToBeCompleted.size();
                return d;
            }
            finally {
                this.hasFinishedAddingTasks.release();
            }
        }
        return 0.0;
    }

    private void createJobs() {
        try {
            this.doCreateJobs();
        }
        finally {
            this.hasFinishedAddingTasks.release();
        }
    }

    @GuardedBy(value="hasFinishedAddingTasks")
    private void doCreateJobs() {
        List futuresList = this.providers.stream().map(provider -> provider.createTasks().stream().map(task -> CompletableFuture.supplyAsync(this.offRequestSupplier((Supplier)task), this.executor)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        CompletableFuture finalCompletableFuture = RecommendationsManager.mergeCompletableFutures(futuresList);
        ((CompletableFuture)finalCompletableFuture.thenAccept(this::storeRecommendations)).whenComplete((nothing, exception) -> {
            if (exception != null) {
                if (exception.getCause() instanceof CancellationException) {
                    log.info("Recommendation provider task has been cancelled");
                } else {
                    log.error("Recommendation provider threw an exception: " + exception.getMessage(), exception);
                    this.failListener.run();
                }
            } else {
                this.finishListener.run();
            }
        });
        this.tasksToBeCompleted.addAll(futuresList);
        this.tasksToBeCompleted.add(finalCompletableFuture);
    }

    private void storeRecommendations(List<Collection<RecommendationBean>> collectionsOfRecommendations) {
        collectionsOfRecommendations.stream().flatMap(Collection::stream).forEach(this::storeRecommendation);
    }

    private void storeRecommendation(RecommendationBean recommendationBean) {
        try {
            this.recommendationsDao.createRecommendation(recommendationBean.getId(), recommendationBean.getName(), recommendationBean.getCategory(), recommendationBean.getCustomFieldId(), recommendationBean.getType(), recommendationBean.getPerformanceImpact(), recommendationBean.getProjectIds());
        }
        catch (Exception e) {
            log.warn("An exception occurred while storing recommendation: {}", (Object)recommendationBean, (Object)e);
        }
    }

    private static <T> CompletableFuture<List<T>> mergeCompletableFutures(List<CompletableFuture<T>> com) {
        return CompletableFuture.allOf(com.toArray(new CompletableFuture[com.size()])).thenApply(v -> com.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public Collection<RecommendationBean> getRecommendations() {
        return Stream.of(this.recommendationsDao.getAllRecommendations()).map(RecommendationBean::new).collect(Collectors.toList());
    }

    @Nullable
    public RecommendationBean getRecommendation(String id) {
        return Optional.ofNullable(this.recommendationsDao.getById(id)).map(RecommendationBean::new).orElse(null);
    }

    void setFinishListener(@NotNull Runnable finishListener) {
        this.finishListener = Objects.requireNonNull(finishListener);
    }

    void setFailListener(@NotNull Runnable failListener) {
        this.failListener = Objects.requireNonNull(failListener);
    }

    private <T> Supplier<T> offRequestSupplier(Supplier<T> supplier) {
        return () -> {
            AtomicReference reference = new AtomicReference();
            this.offRequestThreadExecutor.execute(() -> RecommendationsManager.lambda$null$7(reference, (Supplier)supplier));
            return reference.get();
        };
    }

    private static /* synthetic */ void lambda$null$7(AtomicReference reference, Supplier supplier) {
        reference.set(supplier.get());
    }
}

