/**
 * Marionete application router
 */
define('jira/optimizer-plugin/router', ['jira-optimizer-plugin/backbone-1.1.2', 'jira-optimizer-plugin/marionette-2.1.0', 'jira/optimizer-plugin/headerView', 'jira/optimizer-plugin/statusView', 'jira/optimizer-plugin/categoriesView', 'jira/optimizer-plugin/recommendationsView', 'jira/optimizer-plugin/welcomeView'], function (Backbone, Marionette, HeaderView, StatusView, CategoriesView, RecommendationsView, WelcomeView) {
    'use strict';

    return Backbone.Router.extend({
        initialize: function initialize(options) {
            this.statusModel = options.statusModel;
            this.categoriesCollection = options.categoriesCollection;
            this.layout = options.layout;
        },

        routes: {
            'recommendations/:category': 'recommendations',
            'welcome': 'welcome',
            '': 'home'
        },
        recommendations: function recommendations(category) {
            var categoryModel = this.categoriesCollection.findWhere({ 'category': category });
            if (!categoryModel) {
                return Backbone.history.navigate('', {
                    trigger: true,
                    replace: true
                });
            }

            this.layout.status.empty();
            this.layout.status.$el.hide();

            this.layout.header.show(new HeaderView({
                model: categoryModel
            }));

            this.layout.container.show(new RecommendationsView({
                model: categoryModel
            }));
        },
        welcome: function welcome() {
            this.layout.header.show(new WelcomeView({
                model: this.statusModel
            }));
            // hide the annoying border >:(
            this.layout.status.$el.hide();
        },
        home: function home() {

            // welcome view is displayed on this container, so we need to clear it before displaying actual status
            this.layout.header.empty();
            this.layout.header.show(new HeaderView({
                model: this.statusModel
            }));

            // welcome screen/ recommendations route hides this container
            this.layout.status.$el.show();
            this.layout.status.show(new StatusView({
                model: this.statusModel
            }));

            this.layout.container.show(new CategoriesView({
                model: this.statusModel,
                collection: this.categoriesCollection
            }));
        }
    });
});