/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import java.util.ArrayList;
import java.util.List;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.Actions;
import org.springframework.statemachine.config.builders.StateMachineTransitionBuilder;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.configurers.ChoiceTransitionConfigurer;
import org.springframework.statemachine.config.model.ChoiceData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.guard.Guard;

public class DefaultChoiceTransitionConfigurer<S, E>
extends AnnotationConfigurerAdapter<TransitionsData<S, E>, StateMachineTransitionConfigurer<S, E>, StateMachineTransitionBuilder<S, E>>
implements ChoiceTransitionConfigurer<S, E> {
    private S source;
    private ChoiceData<S, E> first;
    private final List<ChoiceData<S, E>> thens = new ArrayList<ChoiceData<S, E>>();
    private ChoiceData<S, E> last;

    @Override
    public void configure(StateMachineTransitionBuilder<S, E> builder) throws Exception {
        ArrayList choices = new ArrayList();
        if (this.first != null) {
            choices.add(this.first);
        }
        choices.addAll(this.thens);
        if (this.last != null) {
            choices.add(this.last);
        }
        builder.addChoice(this.source, choices);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> source(S source) {
        this.source = source;
        return this;
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> first(S target, Guard<S, E> guard) {
        return this.first(target, guard, null);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> first(S target, Guard<S, E> guard, Action<S, E> action) {
        return this.first(target, guard, action, null);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> first(S target, Guard<S, E> guard, Action<S, E> action, Action<S, E> error) {
        ArrayList actions = new ArrayList();
        if (action != null) {
            actions.add(error != null ? Actions.errorCallingAction(action, error) : action);
        }
        this.first = new ChoiceData<S, E>(this.source, target, guard, actions);
        return this;
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> then(S target, Guard<S, E> guard) {
        return this.then(target, guard, null);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> then(S target, Guard<S, E> guard, Action<S, E> action) {
        return this.then(target, guard, action, null);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> then(S target, Guard<S, E> guard, Action<S, E> action, Action<S, E> error) {
        ArrayList actions = new ArrayList();
        if (action != null) {
            actions.add(error != null ? Actions.errorCallingAction(action, error) : action);
        }
        this.thens.add(new ChoiceData<S, E>(this.source, target, guard, actions));
        return this;
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> last(S target) {
        return this.last(target, null);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> last(S target, Action<S, E> action) {
        return this.last(target, action, null);
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> last(S target, Action<S, E> action, Action<S, E> error) {
        ArrayList actions = new ArrayList();
        if (action != null) {
            actions.add(error != null ? Actions.errorCallingAction(action, error) : action);
        }
        this.last = new ChoiceData(this.source, target, null, actions);
        return this;
    }
}

