/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.common.annotation.configurers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.statemachine.config.common.annotation.AnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.common.annotation.configurers.ResourceConfigurer;
import org.springframework.statemachine.config.common.annotation.configurers.ResourceConfigurerAware;

public class DefaultResourceConfigurer<O, I, B extends AnnotationBuilder<O>>
extends AnnotationConfigurerAdapter<O, I, B>
implements ResourceConfigurer<I> {
    private Set<Resource> resources = new HashSet<Resource>();
    private final DefaultResourceLoader resourceLoader = new DefaultResourceLoader();

    @Override
    public void configure(B builder) throws Exception {
        if (!this.configureResources(builder, this.resources) && builder instanceof ResourceConfigurerAware) {
            ((ResourceConfigurerAware)builder).configureResources(this.resources);
        }
    }

    @Override
    public ResourceConfigurer<I> resources(Set<Resource> resources) {
        this.resources.addAll(resources);
        return this;
    }

    @Override
    public ResourceConfigurer<I> resource(Resource resource) {
        this.resources.add(resource);
        return this;
    }

    @Override
    public ResourceConfigurer<I> resource(String resource) {
        this.resources.add(this.resourceLoader.getResource(resource));
        return this;
    }

    @Override
    public ResourceConfigurer<I> resources(List<String> resources) {
        if (resources != null) {
            for (String resource : resources) {
                this.resource(resource);
            }
        }
        return this;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    protected boolean configureResources(B builder, Set<Resource> resources) {
        return false;
    }
}

