/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.statemachine.support.BeanFactoryTypeConverter;
import org.springframework.statemachine.support.ExpressionUtils;

public abstract class AbstractExpressionEvaluator
implements BeanFactoryAware,
InitializingBean {
    private volatile StandardEvaluationContext evaluationContext;
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final BeanFactoryTypeConverter typeConverter = new BeanFactoryTypeConverter();
    private volatile BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory != null) {
            this.beanFactory = beanFactory;
            this.typeConverter.setBeanFactory(beanFactory);
            if (this.evaluationContext != null && this.evaluationContext.getBeanResolver() == null) {
                this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.getEvaluationContext();
    }

    public void setConversionService(ConversionService conversionService) {
        if (conversionService != null) {
            this.typeConverter.setConversionService(conversionService);
        }
    }

    protected StandardEvaluationContext getEvaluationContext() {
        return this.getEvaluationContext(true);
    }

    protected final StandardEvaluationContext getEvaluationContext(boolean beanFactoryRequired) {
        if (this.evaluationContext == null) {
            this.evaluationContext = this.beanFactory == null && !beanFactoryRequired ? ExpressionUtils.createStandardEvaluationContext() : ExpressionUtils.createStandardEvaluationContext(this.beanFactory);
            if (this.typeConverter != null) {
                this.evaluationContext.setTypeConverter((TypeConverter)this.typeConverter);
            }
        }
        return this.evaluationContext;
    }

    protected Object evaluateExpression(String expression, Object input) {
        return this.evaluateExpression(expression, input, (Class)null);
    }

    protected <T> T evaluateExpression(String expression, Object input, Class<T> expectedType) {
        return (T)this.expressionParser.parseExpression(expression).getValue((EvaluationContext)this.getEvaluationContext(), input, expectedType);
    }

    protected Object evaluateExpression(Expression expression, Object input) {
        return this.evaluateExpression(expression, input, (Class)null);
    }

    protected <T> T evaluateExpression(Expression expression, Class<T> expectedType) {
        return (T)expression.getValue((EvaluationContext)this.getEvaluationContext(), expectedType);
    }

    protected Object evaluateExpression(Expression expression) {
        return expression.getValue((EvaluationContext)this.getEvaluationContext());
    }

    protected <T> T evaluateExpression(Expression expression, Object input, Class<T> expectedType) {
        return (T)expression.getValue((EvaluationContext)this.getEvaluationContext(), input, expectedType);
    }
}

