/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractSimpleState;
import org.springframework.statemachine.state.PseudoState;

public class ObjectState<S, E>
extends AbstractSimpleState<S, E> {
    private static final Log log = LogFactory.getLog(ObjectState.class);

    public ObjectState(S id) {
        super(id);
    }

    public ObjectState(S id, PseudoState<S, E> pseudoState) {
        super(id, pseudoState);
    }

    public ObjectState(S id, Collection<E> deferred) {
        super(id, deferred);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions) {
        super(id, deferred, entryActions, exitActions);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState) {
        super(id, deferred, entryActions, exitActions, pseudoState);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions) {
        super(id, deferred, entryActions, exitActions, pseudoState, regions);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, StateMachine<S, E> submachine) {
        super(id, deferred, entryActions, exitActions, pseudoState, submachine);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, Collection<? extends Action<S, E>> stateActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        super(id, deferred, entryActions, exitActions, stateActions, pseudoState, regions, submachine);
    }

    @Override
    public void exit(StateContext<S, E> context) {
        super.exit(context);
        for (Action action : this.getExitActions()) {
            try {
                this.executeAction(action, context);
            }
            catch (Exception e) {
                log.error((Object)"Action execution resulted error", (Throwable)e);
            }
        }
    }

    @Override
    public void entry(StateContext<S, E> context) {
        super.entry(context);
        for (Action action : this.getEntryActions()) {
            try {
                this.executeAction(action, context);
            }
            catch (Exception e) {
                log.error((Object)"Action execution resulted error", (Throwable)e);
            }
        }
    }

    @Override
    public String toString() {
        return "ObjectState [getIds()=" + this.getIds() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }
}

