/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.statemachine.processor.MethodAnnotationPostProcessor;
import org.springframework.statemachine.processor.StateMachineHandler;

public class StateMachineActivatorAnnotationPostProcessor<T extends Annotation>
implements MethodAnnotationPostProcessor<T> {
    protected final BeanFactory beanFactory;

    public StateMachineActivatorAnnotationPostProcessor(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcess(Class<?> beanClass, Object bean, String beanName, Method method, T metaAnnotation, Annotation annotation) {
        StateMachineHandler handler = new StateMachineHandler(beanClass, bean, method, metaAnnotation, annotation);
        Integer order = StateMachineActivatorAnnotationPostProcessor.findOrder(bean, method);
        if (order != null) {
            handler.setOrder(order);
        }
        return handler;
    }

    private static Integer findOrder(Object bean, Method method) {
        Integer order = OrderUtils.getOrder(bean.getClass());
        Order ann = (Order)AnnotationUtils.findAnnotation((Method)method, Order.class);
        if (ann != null) {
            order = ann.value();
        }
        return order;
    }
}

