define('jira/inline-issue-create/agile/widget', [
    'jira/inline-issue-create/widget',
    'jira/inline-issue-create/agile/helppath-constants'
], function (
    IicWidget,
    HelpPathConstants
) {
    "use strict";

    var AgileIicWidget = IicWidget.extend({
        activate: function activate() {
            if (this.model.getLockState() === this.model.constants.STATE_LOCK_PERM_INACTIVE) {
                var dialog = this.openCreateIssueDialog();
                dialog.done(function (dialog) {
                    dialog.onContentReady(function () {
                        JIRA.applyMessageToForm("info", dialog.$form, JIRA.Templates.InlineIssueCreate.Agile.configurationIssue({url: HelpPathConstants.configureBoard.url}), true);
                    });
                });
                return false;
            }
            return IicWidget.prototype.activate.call(this);
        }
    });

    return AgileIicWidget;
});
