define('jira/inline-issue-create/entities/inline-bootstrap', [
    'backbone',
    'underscore',
    'wrm/context-path',
    'jira/util/logger',
    'jira/inline-issue-create/lib/brace',
    'jira/inline-issue-create/entities/projects',
    'jira/inline-issue-create/entities/issue-types'
], function (
    Backbone,
    _,
    wrmContextPath,
    logger,
    Brace,
    ProjectsCollection,
    IssueTypesCollection
    ) {
    "use strict";

    return Brace.Model.extend({

        issueTypesCollectionType: IssueTypesCollection,
        projectsCollectionType: ProjectsCollection,

        namedAttributes: {
            hasCreateIssuePermission: "boolean",
            hasScheduleIssuePermission: "boolean"
        },

        initialize : function initialize(){
            this.issueTypes = new this.issueTypesCollectionType();
            this.projects = new this.projectsCollectionType();
        },

        url: function url() {
            var queries = _.map(this.jqls, function (jql) {return "query=" + encodeURIComponent(jql) + "&";});
            return wrmContextPath() + "/rest/inline-create/1.0/context/bootstrap"+ "?".concat.apply("?", queries);
        },
        _initializeState: function _initializeState(attributes, options) {
            if (options && options.jqls) {
                this.jqls = options.jqls;
            } else {
                this.jqls = undefined;
            }

            this.fetching = false;
            this.initialized = false;
        },
        setJQLs: function setJQLs(jqls) {
            if (_.isEqual(this.jqls, jqls)) {
                return;
            }
            this.jqls = jqls;
            this.fetch({reset: true});
        },
        parse: function parse(response) {
            var instance = this;
            // SW-1051 - brace doesn't allow to pass extra attributes
            var issueTypes = _.map(response.issueTypes.values, function(issueType) {
                return _.pick(issueType, _.keys(instance.issueTypes.model.prototype.namedAttributes));
            });
            this.issueTypes.reset(issueTypes);

            var projects = _.map(response.projects.values, function(project) {
                return _.pick(project, _.keys(instance.projects.model.prototype.namedAttributes));
            });
            this.projects.reset(projects);

            return _.pick(response, "hasCreateIssuePermission", "hasScheduleIssuePermission");
        },
        fetch: function fetch(options) {
            var model = this;

            function triggerFetched() {
                model.fetching = false;
                model.initialized = true;
                logger.trace("inline.create.bootstrap.fetched");
            }

            options = options || {};
            if (options.success) {
                options.success = _.wrap(options.success, function successWrapper(originalSuccessHandler) {
                    triggerFetched();
                    return originalSuccessHandler.apply(model, Array.prototype.slice.call(arguments, 1));
                });
            } else {
                options.success = triggerFetched;
            }
            this.fetching = true;
            logger.trace("inline.create.bootstrap.fetching");
            return Backbone.Model.prototype.fetch.call(this, options);
        },
        isInitialized: function isInitialized() {
            return this.initialized;
        },
        isFetching: function isFetching() {
            return this.fetching;
        },
        fireWhenInitialized: function fireWhenInitialized(func) {
            if(this.isInitialized() && (!this.isFetching())){
                func();
            } else {
                this.listenToOnce(this, "sync", func);
            }
        }
    });
});
