/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.rendering;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.inform.api.batching.Template;
import java.util.Map;
import java.util.Optional;
import org.apache.velocity.exception.VelocityException;

public class VelocityTemplate
implements Template {
    private static final String ERROR_PREFIX = "An error occurred whilst rendering this message.  Please contact the administrators, and inform them of this bug.";
    final String bodyTemplate;
    final String subjectTemplate;
    final Optional<String> cssContent;

    public VelocityTemplate(String bodyTemplate, String subjectTemplate, Optional<String> cssContent) {
        this.bodyTemplate = bodyTemplate;
        this.subjectTemplate = subjectTemplate;
        this.cssContent = cssContent;
    }

    public String renderSubject(Map<String, Object> context) {
        return this.render(context, this.subjectTemplate);
    }

    public String renderContent(Map<String, Object> context) {
        return this.render(context, this.bodyTemplate);
    }

    public Optional<String> getCssContent() {
        return this.cssContent;
    }

    private String render(Map<String, Object> context, String template) {
        String renderedText = ComponentAccessor.getVelocityManager().getEncodedBodyForContent(template, ComponentAccessor.getApplicationProperties().getString("jira.baseurl"), context);
        if (renderedText != null && renderedText.startsWith(ERROR_PREFIX)) {
            throw new VelocityException(renderedText);
        }
        return renderedText;
    }
}

