/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.recipients;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.inform.api.events.IssueEventParameter;
import com.atlassian.jira.plugins.inform.batching.recipients.BatchingNotificationFiterManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MentionedRecipientRetriever {
    private final BatchingNotificationFiterManager batchingNotificationFiterManager;
    private final MentionService mentionService;

    @Autowired
    public MentionedRecipientRetriever(BatchingNotificationFiterManager batchingNotificationFiterManager, @ComponentImport MentionService mentionService) {
        this.batchingNotificationFiterManager = batchingNotificationFiterManager;
        this.mentionService = mentionService;
    }

    public Stream<ApplicationUser> get(IssueEvent issueEvent) {
        if (!issueEvent.isSendMail()) {
            return Stream.of(new ApplicationUser[0]);
        }
        NotificationFilterContext context = this.batchingNotificationFiterManager.makeContextFrom((NotificationReason)JiraNotificationReason.MENTIONED, issueEvent);
        List recipients = this.extractMentionedUsers(issueEvent).stream().map(NotificationRecipient::new).collect(Collectors.toList());
        return StreamSupport.stream(this.batchingNotificationFiterManager.recomputeRecipients(recipients, context).spliterator(), false).map(NotificationRecipient::getUser);
    }

    private Set<ApplicationUser> extractMentionedUsers(IssueEvent issueEvent) {
        MentionService.Mentions mentionedUsers = this.mentionService.getMentionedUsers(issueEvent);
        Stream<Object> issueCommentMentions = mentionedUsers.getIssueCommentMentions().stream();
        if (((Boolean)IssueEventParameter.SKIP_ENTITY_NEW_PARAMETER.get(issueEvent)).booleanValue()) {
            issueCommentMentions = Stream.empty();
        }
        return Stream.concat(mentionedUsers.getIssueDescriptionMentions().stream(), issueCommentMentions).collect(Collectors.toSet());
    }
}

