/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching;

import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueueItem;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostprocessingMailQueueItem
implements MailQueueItem {
    private static final Logger LOG = LoggerFactory.getLogger(PostprocessingMailQueueItem.class);
    final MailQueueItem delegate;
    final Runnable successCallback;
    final Runnable errorCallback;

    public PostprocessingMailQueueItem(@Nonnull MailQueueItem delegate, @Nonnull Runnable successCallback, @Nonnull Runnable errorCallback) {
        this.delegate = Objects.requireNonNull(delegate);
        this.successCallback = Objects.requireNonNull(successCallback);
        this.errorCallback = Objects.requireNonNull(errorCallback);
    }

    public void send() throws MailException {
        try {
            this.delegate.send();
            this.runSafely(this.successCallback);
        }
        catch (MailException me) {
            this.runSafely(this.errorCallback);
            throw me;
        }
    }

    public String getSubject() {
        return this.delegate.getSubject();
    }

    public Date getDateQueued() {
        return this.delegate.getDateQueued();
    }

    public int getSendCount() {
        return this.delegate.getSendCount();
    }

    public boolean hasError() {
        return this.delegate.hasError();
    }

    public int compareTo(MailQueueItem o) {
        return this.delegate.compareTo((Object)o);
    }

    private void runSafely(Runnable callback) {
        try {
            callback.run();
        }
        catch (Exception e) {
            LOG.error("Error during executing callback", (Throwable)e);
        }
    }

    public MailQueueItem getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return "PostprocessingMailQueueItem{delegate=" + this.delegate + '}';
    }
}

