/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.inform.api.batching.BatchingType;
import com.atlassian.jira.plugins.inform.api.batching.InstancePreferencesService;
import com.atlassian.jira.plugins.inform.batching.configuration.FeatureUsageManager;
import com.atlassian.jira.plugins.inform.flags.JiraInformFeatureFlags;
import com.atlassian.jira.util.Longs;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class InstancePreferencesServiceImpl
implements InstancePreferencesService {
    private final PluginSettings pluginSettings;
    private final FeatureManager featureManager;
    private final FeatureUsageManager featureUsageManager;
    private final String INSTANCE_CONFIGURATION_KEY = "instance-configuration";
    @VisibleForTesting
    static final String MAX_FETCHED_EVENTS_NUMBER_SETTING_KEY = "com.atlassian.jira.plugins.inform.jira-inform-plugin:batching.max.fetched.events.number";
    @VisibleForTesting
    static final long DEFAULT_MAX_FETCHED_EVENTS_NUMBER = 10000L;

    @Autowired
    InstancePreferencesServiceImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport FeatureManager featureManager, FeatureUsageManager featureUsageManager) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.featureManager = featureManager;
        this.featureUsageManager = featureUsageManager;
    }

    @Nonnull
    public BatchingType getBatchingType() {
        BatchingType batchingType;
        Object savedPreference = this.pluginSettings.get("instance-configuration");
        if (savedPreference == null) {
            batchingType = BatchingType.SHORT;
            this.updateBatchingType(batchingType);
        } else {
            int interval = Integer.parseInt(savedPreference.toString());
            batchingType = BatchingType.getByValue((int)interval);
        }
        return batchingType;
    }

    public void updateBatchingType(@Nonnull BatchingType batchingType) {
        this.pluginSettings.put("instance-configuration", (Object)Integer.toString(batchingType.getValue()));
    }

    public void enableBatching() {
        this.featureUsageManager.markFeatureEnabled();
        this.featureManager.enableSiteDarkFeature(JiraInformFeatureFlags.MAIL_BATCHING.enabledFeatureKey());
    }

    public void disableBatching() {
        this.featureUsageManager.markFeatureEnabled();
        this.featureManager.disableSiteDarkFeature(JiraInformFeatureFlags.MAIL_BATCHING.enabledFeatureKey());
    }

    public void setMaxReturnedEventsNumber(long number) {
        assert (number > 0L) : "The max returned events number has to be greater than zero!";
        this.pluginSettings.put(MAX_FETCHED_EVENTS_NUMBER_SETTING_KEY, (Object)Long.toString(number));
    }

    public long getMaxReturnedEventsNumber() {
        return Optional.ofNullable(this.pluginSettings.get(MAX_FETCHED_EVENTS_NUMBER_SETTING_KEY)).flatMap(val -> Longs.toLongMaybe((String)Objects.toString(val))).orElse(10000L);
    }
}

