/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.SearchResultJsonParser;
import com.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousSearchRestClient
extends AbstractAsynchronousRestClient
implements SearchRestClient {
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final int MAX_JQL_LENGTH_FOR_HTTP_GET = 500;
    private static final String JQL_ATTRIBUTE = "jql";
    private final SearchResultJsonParser searchResultJsonParser = new SearchResultJsonParser();
    private static final String SEARCH_URI_PREFIX = "search";
    private final URI searchUri;

    public AsynchronousSearchRestClient(URI baseUri, HttpClient asyncHttpClient) {
        super(asyncHttpClient);
        this.searchUri = UriBuilder.fromUri((URI)baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
    }

    @Override
    public Promise<SearchResult> searchJql(@Nullable String jql) {
        if (jql == null) {
            jql = "";
        }
        if (jql.length() > 500) {
            JSONObject postEntity = new JSONObject();
            try {
                postEntity.put(JQL_ATTRIBUTE, (Object)jql);
            }
            catch (JSONException e) {
                throw new RestClientException(e);
            }
            return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser);
        }
        URI uri = UriBuilder.fromUri((URI)this.searchUri).queryParam(JQL_ATTRIBUTE, new Object[]{jql}).build(new Object[0]);
        return this.getAndParse(uri, this.searchResultJsonParser);
    }

    @Override
    public Promise<SearchResult> searchJql(@Nullable String jql, int maxResults, int startAt) {
        if (jql == null) {
            jql = "";
        }
        if (jql.length() > 500) {
            JSONObject postEntity = new JSONObject();
            try {
                postEntity.put(JQL_ATTRIBUTE, (Object)jql);
                postEntity.put(START_AT_ATTRIBUTE, startAt);
                postEntity.put(MAX_RESULTS_ATTRIBUTE, maxResults);
            }
            catch (JSONException e) {
                throw new RestClientException(e);
            }
            return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser);
        }
        URI uri = UriBuilder.fromUri((URI)this.searchUri).queryParam(JQL_ATTRIBUTE, new Object[]{jql}).queryParam(MAX_RESULTS_ATTRIBUTE, new Object[]{maxResults}).queryParam(START_AT_ATTRIBUTE, new Object[]{startAt}).build(new Object[0]);
        return this.getAndParse(uri, this.searchResultJsonParser);
    }
}

