/*
 * Copyright (C) 2011 Atlassian
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.domain.input.VersionInput;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VersionInputJsonGenerator implements JsonGenerator<VersionInput> {
	@Override
	public JSONObject generate(VersionInput version) throws JSONException {
		final JSONObject jsonObject = new JSONObject();
		jsonObject.put("name", version.getName());
		jsonObject.put("project", version.getProjectKey());
		if (version.getDescription() != null) {
			jsonObject.put("description", version.getDescription());
		}
		if (version.getReleaseDate() != null) {
			jsonObject.put("releaseDate", JsonParseUtil.formatDate(version.getReleaseDate()));
		}
		jsonObject.put("released", version.isReleased());
		jsonObject.put("archived", version.isArchived());
		return jsonObject;
	}
}
