/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.BasicWatchers;
import com.atlassian.jira.rest.client.domain.Watchers;
import com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.net.URI;
import java.util.Collection;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class WatchersJsonParserBuilder {
    public static JsonParser<Watchers> createWatchersParser() {
        return new JsonParser<Watchers>(){
            private final BasicUserJsonParser userJsonParser = new BasicUserJsonParser();

            @Override
            public Watchers parse(JSONObject json) throws JSONException {
                Collection<BasicUser> watchers = JsonParseUtil.parseJsonArray(json.getJSONArray("watchers"), this.userJsonParser);
                return new Watchers(WatchersJsonParserBuilder.parseValueImpl(json), watchers);
            }
        };
    }

    public static JsonParser<BasicWatchers> createBasicWatchersParser() {
        return new JsonParser<BasicWatchers>(){

            @Override
            public BasicWatchers parse(JSONObject json) throws JSONException {
                return WatchersJsonParserBuilder.parseValueImpl(json);
            }
        };
    }

    private static BasicWatchers parseValueImpl(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        boolean isWatching = json.getBoolean("isWatching");
        int numWatchers = json.getInt("watchCount");
        return new BasicWatchers(self, isWatching, numWatchers);
    }
}

