/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.ExpandableProperty;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.User;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class UserJsonParser
implements JsonParser<User> {
    @Override
    public User parse(JSONObject json) throws JSONException {
        BasicUser basicUser = JsonParseUtil.parseBasicUser(json);
        String timezone = JsonParseUtil.getOptionalString(json, "timeZone");
        String avatarUrl = JsonParseUtil.getOptionalString(json, "avatarUrl");
        HashMap avatarUris = Maps.newHashMap();
        if (avatarUrl != null) {
            URI avatarUri = JsonParseUtil.parseURI(avatarUrl);
            avatarUris.put(User.S48_48, avatarUri);
        } else {
            JSONObject avatarUrlsJson = json.getJSONObject("avatarUrls");
            Iterator iterator = avatarUrlsJson.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                avatarUris.put(key, JsonParseUtil.parseURI(avatarUrlsJson.getString(key)));
            }
        }
        String emailAddress = json.getString("emailAddress");
        ExpandableProperty<String> groups = JsonParseUtil.parseExpandableProperty(json.getJSONObject("groups"), new JsonParser<String>(){

            @Override
            public String parse(JSONObject json) throws JSONException {
                return json.getString("name");
            }
        });
        return new User(basicUser.getSelf(), basicUser.getName(), basicUser.getDisplayName(), emailAddress, groups, avatarUris, timezone);
    }
}

