/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonFieldParser {
    private static final String VALUE_ATTRIBUTE = "value";
    private Map<String, JsonParser> registeredValueParsers = new HashMap<String, JsonParser>(){
        {
            this.put("com.atlassian.jira.plugin.system.customfieldtypes:float", new FloatingPointFieldValueParser());
            this.put("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", new FieldValueJsonParser<BasicUser>(new BasicUserJsonParser()));
            this.put("java.lang.String", new StringFieldValueParser());
        }
    };

    public Field parse(JSONObject jsonObject, String id) throws JSONException {
        JsonParser valueParser;
        String type = jsonObject.getString("type");
        String name = jsonObject.getString("name");
        Object valueObject = jsonObject.opt(VALUE_ATTRIBUTE);
        if ("comment".equals(name)) {
            type = "com.atlassian.jira.Comment";
        }
        Object value = valueObject == null ? null : ((valueParser = this.registeredValueParsers.get(type)) != null ? valueParser.parse(jsonObject) : valueObject.toString());
        return new Field(id, name, type, value);
    }

    static class StringFieldValueParser
    implements JsonParser<String> {
        StringFieldValueParser() {
        }

        @Override
        public String parse(JSONObject jsonObject) throws JSONException {
            return JsonParseUtil.getNullableString(jsonObject, JsonFieldParser.VALUE_ATTRIBUTE);
        }
    }

    static class FloatingPointFieldValueParser
    implements JsonParser<Double> {
        FloatingPointFieldValueParser() {
        }

        @Override
        public Double parse(JSONObject jsonObject) throws JSONException {
            String s = JsonParseUtil.getNullableString(jsonObject, JsonFieldParser.VALUE_ATTRIBUTE);
            if (s == null) {
                return null;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new JSONException("[" + s + "] is not a valid floating point number");
            }
        }
    }

    static class FieldValueJsonParser<T>
    implements JsonParser<T> {
        private final JsonParser<T> jsonParser;

        public FieldValueJsonParser(JsonParser<T> jsonParser) {
            this.jsonParser = jsonParser;
        }

        @Override
        public T parse(JSONObject json) throws JSONException {
            JSONObject valueObject = json.optJSONObject(JsonFieldParser.VALUE_ATTRIBUTE);
            if (valueObject == null) {
                throw new JSONException("Expected JSONObject with [value] attribute present.");
            }
            return this.jsonParser.parse(valueObject);
        }
    }
}

