/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Attachment;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.BasicResolution;
import com.atlassian.jira.rest.client.domain.BasicStatus;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.BasicVotes;
import com.atlassian.jira.rest.client.domain.BasicWatchers;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueLink;
import com.atlassian.jira.rest.client.domain.TimeTracking;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.atlassian.jira.rest.client.internal.json.AttachmentJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicIssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicPriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicStatusJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicVotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.CommentJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonFieldParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParser;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParserForJsonObject;
import com.atlassian.jira.rest.client.internal.json.TimeTrackingJsonParser;
import com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.WorklogJsonParser;
import com.google.common.base.Splitter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class IssueJsonParser
implements JsonParser<Issue> {
    private static final String UPDATED_ATTR = "updated";
    private static final String CREATED_ATTR = "created";
    private static final String AFFECTS_VERSIONS_ATTR = "versions";
    private static final String FIX_VERSIONS_ATTR = "fixVersions";
    private static final String COMPONENTS_ATTR = "components";
    private static final String LINKS_ATTR = "links";
    private static final String ISSUE_TYPE_ATTR = "issuetype";
    private static final String VOTES_ATTR = "votes";
    private static final String WORKLOG_ATTR = "worklog";
    private static final String WATCHER_ATTR = "watcher";
    private static final String PROJECT_ATTR = "project";
    private static final String STATUS_ATTR = "status";
    private static final String COMMENT_ATTR = "comment";
    private static final String PRIORITY_ATTR = "priority";
    private static final String ATTACHMENT_ATTR = "attachment";
    private static final String RESOLUTION_ATTR = "resolution";
    private static final String ASSIGNEE_ATTR = "assignee";
    private static final String REPORTER_ATTR = "reporter";
    private static final String SUMMARY_ATTR = "summary";
    private static Set<String> SPECIAL_FIELDS = new HashSet<String>(Arrays.asList("summary", "updated", "created", "versions", "fixVersions", "components", "links", "issuetype", "votes", "worklog", "watcher", "project", "status", "comment", "attachment", "summary", "priority", "resolution", "assignee", "reporter"));
    private final IssueLinkJsonParser issueLinkJsonParser = new IssueLinkJsonParser();
    private final BasicVotesJsonParser votesJsonParser = new BasicVotesJsonParser();
    private final BasicStatusJsonParser statusJsonParser = new BasicStatusJsonParser();
    private final WorklogJsonParser worklogJsonParser = new WorklogJsonParser();
    private final JsonParser<BasicWatchers> watchersJsonParser = WatchersJsonParserBuilder.createBasicWatchersParser();
    private final VersionJsonParser versionJsonParser = new VersionJsonParser();
    private final BasicComponentJsonParser basicComponentJsonParser = new BasicComponentJsonParser();
    private final AttachmentJsonParser attachmentJsonParser = new AttachmentJsonParser();
    private final JsonFieldParser fieldParser = new JsonFieldParser();
    private final CommentJsonParser commentJsonParser = new CommentJsonParser();
    private final BasicIssueTypeJsonParser issueTypeJsonParser = new BasicIssueTypeJsonParser();
    private final BasicProjectJsonParser projectJsonParser = new BasicProjectJsonParser();
    private final BasicPriorityJsonParser priorityJsonParser = new BasicPriorityJsonParser();
    private final BasicResolutionJsonParser resolutionJsonParser = new BasicResolutionJsonParser();
    private final BasicUserJsonParser userJsonParser = new BasicUserJsonParser();
    private static final String FIELDS = "fields";
    private static final String VALUE_ATTR = "value";

    static Iterable<String> parseExpandos(JSONObject json) throws JSONException {
        String expando = json.getString("expand");
        return Splitter.on((char)',').split((CharSequence)expando);
    }

    private <T> Collection<T> parseArray(JSONObject jsonObject, JsonWeakParser<T> jsonParser) throws JSONException {
        JSONArray valueObject = jsonObject.optJSONArray(VALUE_ATTR);
        if (valueObject == null) {
            return new ArrayList();
        }
        ArrayList<T> res = new ArrayList<T>(valueObject.length());
        for (int i = 0; i < valueObject.length(); ++i) {
            res.add(jsonParser.parse(valueObject.get(i)));
        }
        return res;
    }

    @Nullable
    private <T> Collection<T> parseOptionalArray(JSONObject json, JsonWeakParser<T> jsonParser, String ... path) throws JSONException {
        JSONObject js = JsonParseUtil.getNestedOptionalObject(json, path);
        if (js == null) {
            return null;
        }
        return this.parseArray(js, jsonParser);
    }

    @Override
    public Issue parse(JSONObject s) throws JSONException {
        JSONObject commentsJs = JsonParseUtil.getNestedObject(s, FIELDS, COMMENT_ATTR);
        Collection<Object> comments = commentsJs != null ? this.parseArray(commentsJs, new JsonWeakParserForJsonObject<Comment>(this.commentJsonParser)) : new ArrayList();
        String summary = JsonParseUtil.getNestedString(s, FIELDS, SUMMARY_ATTR, VALUE_ATTR);
        Collection<Attachment> attachments = this.parseOptionalArray(s, new JsonWeakParserForJsonObject<Attachment>(this.attachmentJsonParser), FIELDS, ATTACHMENT_ATTR);
        Iterable<String> expandos = IssueJsonParser.parseExpandos(s);
        Collection<Field> fields = this.parseFields(s.getJSONObject(FIELDS));
        BasicIssueType issueType = this.issueTypeJsonParser.parse(JsonParseUtil.getNestedObject(s, FIELDS, ISSUE_TYPE_ATTR, VALUE_ATTR));
        DateTime creationDate = JsonParseUtil.parseDateTime(JsonParseUtil.getNestedString(s, FIELDS, CREATED_ATTR, VALUE_ATTR));
        DateTime updateDate = JsonParseUtil.parseDateTime(JsonParseUtil.getNestedString(s, FIELDS, UPDATED_ATTR, VALUE_ATTR));
        BasicPriority priority = this.getOptionalField(s, PRIORITY_ATTR, this.priorityJsonParser);
        BasicResolution resolution = this.getOptionalField(s, RESOLUTION_ATTR, this.resolutionJsonParser);
        BasicUser assignee = this.getOptionalField(s, ASSIGNEE_ATTR, this.userJsonParser);
        BasicUser reporter = this.getOptionalField(s, REPORTER_ATTR, this.userJsonParser);
        URI transitionsUri = JsonParseUtil.parseURI(s.getString("transitions"));
        BasicProject project = this.projectJsonParser.parse(JsonParseUtil.getNestedObject(s, FIELDS, PROJECT_ATTR, VALUE_ATTR));
        Collection<IssueLink> issueLinks = this.parseOptionalArray(s, new JsonWeakParserForJsonObject<IssueLink>(this.issueLinkJsonParser), FIELDS, LINKS_ATTR);
        BasicVotes votes = this.getOptionalField(s, VOTES_ATTR, this.votesJsonParser);
        BasicStatus status = this.statusJsonParser.parse(JsonParseUtil.getNestedObject(s, FIELDS, STATUS_ATTR, VALUE_ATTR));
        Collection<Version> fixVersions = this.parseOptionalArray(s, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, FIX_VERSIONS_ATTR);
        Collection<Version> affectedVersions = this.parseOptionalArray(s, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, AFFECTS_VERSIONS_ATTR);
        Collection<BasicComponent> components = this.parseOptionalArray(s, new JsonWeakParserForJsonObject<BasicComponent>(this.basicComponentJsonParser), FIELDS, COMPONENTS_ATTR);
        Collection<Worklog> worklogs = this.parseOptionalArray(s, new JsonWeakParserForJsonObject<Worklog>(this.worklogJsonParser), FIELDS, WORKLOG_ATTR);
        BasicWatchers watchers = this.getOptionalField(s, WATCHER_ATTR, this.watchersJsonParser);
        TimeTracking timeTracking = this.getOptionalField(s, "timetracking", new TimeTrackingJsonParser());
        return new Issue(summary, JsonParseUtil.getSelfUri(s), s.getString("key"), project, issueType, status, priority, resolution, attachments, reporter, assignee, creationDate, updateDate, affectedVersions, fixVersions, components, timeTracking, fields, comments, transitionsUri, issueLinks, votes, worklogs, watchers, expandos);
    }

    @Nullable
    private <T> T getOptionalField(JSONObject s, String fieldId, JsonParser<T> jsonParser) throws JSONException {
        JSONObject valueJsonObject;
        JSONObject fieldJson = JsonParseUtil.getNestedOptionalObject(s, FIELDS, fieldId);
        if (fieldJson != null && (valueJsonObject = fieldJson.optJSONObject(VALUE_ATTR)) != null) {
            return jsonParser.parse(valueJsonObject);
        }
        return null;
    }

    private Collection<Field> parseFields(JSONObject json) throws JSONException {
        ArrayList<Field> res = new ArrayList<Field>(json.length());
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (SPECIAL_FIELDS.contains(key)) continue;
            try {
                res.add(this.fieldParser.parse(json.getJSONObject(key), key));
            }
            catch (JSONException e) {
                JSONException jsonException = new JSONException("Cannot parse field [" + key + "]");
                jsonException.initCause((Throwable)e);
                throw jsonException;
            }
        }
        return res;
    }
}

