/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.test.matchers;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RestClientExceptionMatchers {
    public static Matcher<RestClientException> rceWithSingleError(final Integer statusCode, final String expectedErrorMessage) {
        return new BaseMatcher<RestClientException>(){

            public boolean matches(Object item) {
                if (item instanceof RestClientException) {
                    RestClientException ex = (RestClientException)((Object)item);
                    Matcher errorMessageMatcher = Matchers.contains((Object[])new String[]{expectedErrorMessage});
                    return ((Integer)ex.getStatusCode().get()).equals(statusCode) && ex.getErrorCollections().size() == 1 && errorMessageMatcher.matches((Object)((ErrorCollection)ex.getErrorCollections().iterator().next()).getErrorMessages());
                }
                return false;
            }

            public void describeTo(Description description) {
                ErrorCollection expectedErrorCollection = ErrorCollection.builder().errorMessage(expectedErrorMessage).status(statusCode.intValue()).build();
                RestClientException expectedException = new RestClientException((Collection)ImmutableList.of((Object)expectedErrorCollection), statusCode.intValue());
                description.appendText("<" + expectedException.toString() + ">");
            }
        };
    }
}

