/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.test.matchers;

import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;

public class IssueMatchers {
    public static Matcher<? super BasicIssue> withIssueKey(String issueKey) {
        return new FeatureMatcher<BasicIssue, String>(Matchers.is((Object)issueKey), "issue with key that", "key"){

            protected String featureValueOf(BasicIssue basicIssue) {
                return basicIssue.getKey();
            }
        };
    }

    public static Matcher<Iterable<? extends BasicIssue>> issuesWithKeys(String ... keys) {
        ArrayList matchers = Lists.newArrayListWithCapacity((int)keys.length);
        for (String key : keys) {
            matchers.add(IssueMatchers.withIssueKey(key));
        }
        return IsIterableContainingInAnyOrder.containsInAnyOrder((Collection)matchers);
    }
}

