/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.test.matchers;

import com.atlassian.jira.rest.client.api.NamedEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;

public class NamedEntityMatchers {
    public static Matcher<? super NamedEntity> withName(String name) {
        return new FeatureMatcher<NamedEntity, String>(Matchers.is((Object)name), "entity with name that", "name"){

            protected String featureValueOf(NamedEntity namedEntity) {
                return namedEntity.getName();
            }
        };
    }

    public static Matcher<Iterable<? extends NamedEntity>> entitiesWithNames(String ... names) {
        ArrayList matchers = Lists.newArrayListWithCapacity((int)names.length);
        for (String key : names) {
            matchers.add(NamedEntityMatchers.withName(key));
        }
        return IsIterableContainingInAnyOrder.containsInAnyOrder((Collection)matchers);
    }
}

