/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client;

import com.atlassian.jira.rest.client.TestUtil;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class IntegrationTestUtil {
    public static final User USER_ADMIN_FULL;
    public static final BasicUser USER_ADMIN;
    public static final BasicUser USER_ADMIN_LATEST;
    public static final User USER1_FULL;
    public static final BasicUser USER1;
    public static final BasicUser USER2;
    public static final BasicUser USER1_LATEST;
    public static final BasicUser USER2_LATEST;
    public static final BasicUser USER_SLASH;
    public static final BasicUser USER_SLASH_LATEST;
    public static final String ROLE_ADMINISTRATORS = "Administrators";
    public static final boolean TESTING_JIRA_5_OR_NEWER;
    public static final int START_PROGRESS_TRANSITION_ID = 4;
    public static final int STOP_PROGRESS_TRANSITION_ID = 301;
    public static final String NUMERIC_CUSTOMFIELD_ID = "customfield_10000";
    public static final String NUMERIC_CUSTOMFIELD_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:float";
    public static final String NUMERIC_CUSTOMFIELD_TYPE_V5 = "number";
    private static final LocalTestEnvironmentData environmentData;
    private static final String URI_INTERFIX_FOR_USER;
    public static final String GROUP_JIRA_ADMINISTRATORS = "jira-administrators";

    private static URI getUserUri(String username) throws URISyntaxException {
        return UriBuilder.fromUri((URI)environmentData.getBaseUrl().toURI()).path("/rest/api/" + URI_INTERFIX_FOR_USER + "/user").queryParam("username", new Object[]{username}).build(new Object[0]);
    }

    private static URI getLatestUserUri(String username) throws URISyntaxException {
        return UriBuilder.fromUri((URI)environmentData.getBaseUrl().toURI()).path("/rest/api/latest/user").queryParam("username", new Object[]{username}).build(new Object[0]);
    }

    public static URI concat(URI uri, String path) {
        return UriBuilder.fromUri((URI)uri).path(path).build(new Object[0]);
    }

    public static URI resolveURI(URI relativeUri) {
        try {
            return IntegrationTestUtil.concat(environmentData.getBaseUrl().toURI(), "/").resolve(relativeUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI resolveURI(String relativeUri) {
        return IntegrationTestUtil.resolveURI(TestUtil.toUri(relativeUri));
    }

    static {
        environmentData = new LocalTestEnvironmentData();
        try {
            AsynchronousJiraRestClientFactory clientFactory = new AsynchronousJiraRestClientFactory();
            JiraRestClient client = clientFactory.create(environmentData.getBaseUrl().toURI(), (AuthenticationHandler)new BasicHttpAuthenticationHandler("admin", "admin"));
            TESTING_JIRA_5_OR_NEWER = ((ServerInfo)client.getMetadataClient().getServerInfo().claim()).getBuildNumber() > 700;
            URI_INTERFIX_FOR_USER = TESTING_JIRA_5_OR_NEWER ? "2" : "latest";
            USER1_FULL = new User(IntegrationTestUtil.getUserUri("wseliga"), "wseliga", "Wojciech Seliga", "wojciech.seliga@spartez.com", null, (Map)ImmutableMap.of((Object)"16x16", (Object)IntegrationTestUtil.resolveURI("secure/useravatar?size=small&avatarId=10082"), (Object)"48x48", (Object)IntegrationTestUtil.resolveURI("secure/useravatar?avatarId=10082")), null);
            USER1 = new BasicUser(USER1_FULL.getSelf(), USER1_FULL.getName(), USER1_FULL.getDisplayName());
            USER1_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("wseliga"), "wseliga", "Wojciech Seliga");
            USER2 = new BasicUser(IntegrationTestUtil.getUserUri("user"), "user", "My Test User");
            USER2_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("user"), "user", "My Test User");
            USER_SLASH = new BasicUser(IntegrationTestUtil.getUserUri("a/user/with/slash"), "a/user/with/slash", "A User with / in its username");
            USER_SLASH_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("a/user/with/slash"), "a/user/with/slash", "A User with / in its username");
            USER_ADMIN_FULL = new User(IntegrationTestUtil.getUserUri("admin"), "admin", "Administrator", "wojciech.seliga@spartez.com", null, (Map)ImmutableMap.of((Object)"16x16", (Object)IntegrationTestUtil.resolveURI("secure/useravatar?size=small&ownerId=admin&avatarId=10054"), (Object)"48x48", (Object)IntegrationTestUtil.resolveURI("secure/useravatar?ownerId=admin&avatarId=10054")), null);
            USER_ADMIN = new BasicUser(USER_ADMIN_FULL.getSelf(), USER_ADMIN_FULL.getName(), USER_ADMIN_FULL.getDisplayName());
            USER_ADMIN_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("admin"), "admin", "Administrator");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

