/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.PercentageProgressCounter;
import com.atlassian.jira.task.context.Sink;
import com.atlassian.jira.util.dbc.Assertions;

@Internal
class PercentageContext
implements Context {
    private final Sink sink;
    private final Progress progress;
    private final Context.Task task = new Context.Task(){

        @Override
        public void complete() {
            PercentageContext.this.progress.increment();
        }
    };

    public PercentageContext(int total, Sink sink) {
        Assertions.notNull("sink", sink);
        this.sink = sink;
        this.progress = new Progress(total);
    }

    @Override
    public Context.Task start(Object input) {
        return this.task;
    }

    @Override
    public void setName(String string) {
        this.sink.setName(string);
        this.progress.update();
    }

    @Override
    public int getNumberOfTasksToCompletion() {
        return this.progress.tasksNotStarted();
    }

    private class Progress {
        private final PercentageProgressCounter counter;
        private final int total;

        Progress(int total) {
            this.counter = new PercentageProgressCounter(total);
            this.total = total;
        }

        void increment() {
            if (this.counter.increment()) {
                this.update();
            }
        }

        int tasksNotStarted() {
            return this.total - this.counter.getCountComplete();
        }

        void update() {
            PercentageContext.this.sink.updateProgress(this.counter.getPercentComplete());
        }
    }
}

